package ru.yandex.solomon.gateway.tasks.deleteMetrics;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;

import ru.yandex.coremon.api.task.DeleteMetricsMoveProgress;
import ru.yandex.coremon.api.task.DeleteMetricsRollbackProgress;
import ru.yandex.gateway.api.task.DeleteMetricsProgress;
import ru.yandex.gateway.api.task.DeleteMetricsResult;
import ru.yandex.gateway.api.task.RemoteTaskProgress;

import static java.util.stream.Collectors.toList;
import static ru.yandex.solomon.util.Proto.unpack;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
@SuppressWarnings("UnnecessaryFullyQualifiedName")
final class DeleteMetricsTaskProto {
    private DeleteMetricsTaskProto() {
    }

    static ru.yandex.gateway.api.task.DeleteMetricsParams params(Any params) {
        return unpack(params, ru.yandex.gateway.api.task.DeleteMetricsParams.class);
    }

    static ru.yandex.coremon.api.task.DeleteMetricsParams remoteParams(Any params) {
        return unpack(params, ru.yandex.coremon.api.task.DeleteMetricsParams.class);
    }

    static DeleteMetricsProgress progress(Any progress) {
        return unpack(progress, DeleteMetricsProgress.getDefaultInstance());
    }

    static DeleteMetricsMoveProgress remoteMoveProgress(Any progress) {
        return unpack(progress, DeleteMetricsMoveProgress.getDefaultInstance());
    }

    static DeleteMetricsRollbackProgress remoteRollbackProgress(Any progress) {
        return unpack(progress, DeleteMetricsRollbackProgress.getDefaultInstance());
    }

    static DeleteMetricsResult result(Any result) {
        return unpack(result, DeleteMetricsResult.getDefaultInstance());
    }

    static ru.yandex.coremon.api.task.DeleteMetricsCheckResult remoteCheckResult(Any result) {
        return unpack(result, ru.yandex.coremon.api.task.DeleteMetricsCheckResult.getDefaultInstance());
    }

    static ru.yandex.coremon.api.task.DeleteMetricsMoveResult remoteMoveResult(Any result) {
        return unpack(result, ru.yandex.coremon.api.task.DeleteMetricsMoveResult.getDefaultInstance());
    }

    static ru.yandex.coremon.api.task.DeleteMetricsTerminateResult remoteTerminateResult(Any result) {
        return unpack(result, ru.yandex.coremon.api.task.DeleteMetricsTerminateResult.getDefaultInstance());
    }

    static DeleteMetricsResult mergeToResult(DeleteMetricsProgress progress) {
        var replicaResults = progress.getTerminateOnReplicasList().stream()
            .map(
                replica -> DeleteMetricsResult.ReplicaResult.newBuilder()
                    .setClusterId(replica.getClusterId())
                    .setDeletedMetrics(
                        replica.getOnShardsList().stream()
                            .mapToInt(DeleteMetricsTaskProto::deletedMetrics)
                            .sum()
                    )
                    .build())
            .collect(toList());

        return DeleteMetricsResult.newBuilder()
            .addAllResults(replicaResults)
            .build();
    }

    private static int deletedMetrics(RemoteTaskProgress remoteTaskProgress) {
        var remoteTask = remoteTaskProgress.getRemoteTask();
        var remoteResult = remoteTerminateResult(remoteTask.getResult());
        return remoteResult.getDeletedMetrics();
    }

}
