package ru.yandex.solomon.gateway.tasks.removeShard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.gateway.api.task.RemoteTaskProgress;
import ru.yandex.gateway.api.task.RemoveShardParams;
import ru.yandex.solomon.coremon.client.CoremonClient;
import ru.yandex.solomon.gateway.tasks.ScatterGather;
import ru.yandex.solomon.util.future.RetryConfig;

/**
 * @author Vladimir Gordiychuk
 */
class RemoveShardFromReplicas implements AutoCloseable {

    private final ScatterGather<RemoteTaskProgress> sg;

    RemoveShardFromReplicas(
        RetryConfig retry,
        CoremonClient coremonClient,
        Executor executor,
        ScheduledExecutorService timer,
        RemoveShardParams params,
        List<RemoteTaskProgress> progressList)
    {
        var clusterIds = coremonClient.clusterIds();
        var unknownClusterId = new HashSet<>(clusterIds);
        var replicas = new ArrayList<RemoveShardFromReplica>(clusterIds.size());

        for (var progress : progressList) {
            unknownClusterId.remove(progress.getClusterId());
            replicas.add(new RemoveShardFromReplica(retry, coremonClient, executor, timer, params, progress));
        }

        for (var clusterId : unknownClusterId) {
            replicas.add(new RemoveShardFromReplica(retry, coremonClient, executor, timer, params, RemoteTaskProgress.newBuilder()
                .setClusterId(clusterId)
                .build()));
        }

        this.sg = new ScatterGather<>(replicas);
    }

    public CompletableFuture<Void> start() {
        return sg.start(false);
    }

    public List<RemoteTaskProgress> progress() {
        return sg.progress();
    }

    @Override
    public void close() {
        sg.close();
    }
}
