package ru.yandex.solomon.gateway.tasks.removeShard;

import java.util.stream.Collectors;

import com.google.protobuf.Any;

import ru.yandex.gateway.api.task.RemoveShardParams;
import ru.yandex.gateway.api.task.RemoveShardProgress;
import ru.yandex.gateway.api.task.RemoveShardResult;
import ru.yandex.gateway.api.task.RemoveShardResult.ReplicaResult;
import ru.yandex.solomon.scheduler.proto.Task;

import static ru.yandex.solomon.util.Proto.unpack;

/**
 * @author Vladimir Gordiychuk
 */
public class RemoveShardTaskProto {
    public static RemoveShardParams params(Any params) {
        return unpack(params, RemoveShardParams.class);
    }

    public static RemoveShardProgress progress(Any progress) {
        return unpack(progress, RemoveShardProgress.getDefaultInstance());
    }

    public static RemoveShardResult result(Any result) {
        return unpack(result, RemoveShardResult.getDefaultInstance());
    }

    public static RemoveShardResult mergeResult(RemoveShardProgress progress) {
        return RemoveShardResult.newBuilder()
                .addAllResults(progress.getRemoveReplicaList()
                        .stream()
                        .map(replica -> ReplicaResult.newBuilder()
                                .setClusterId(replica.getClusterId())
                                .setRemovedMetrics(RemoveShardTaskProto.removedMetrics(replica.getRemoteTask()))
                                .build())
                        .collect(Collectors.toList()))
                .build();
    }

    public static int removedMetrics(Task task) {
        var any = task.getResult();
        var remoteResult = unpack(any, ru.yandex.coremon.api.task.RemoveShardResult.getDefaultInstance());
        return remoteResult.getRemovedMetrics();
    }
}
