package ru.yandex.solomon.gateway.utils;

import java.util.ArrayList;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.gateway.utils.conf.GraphSettingOption;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public enum GraphMode {
    GRAPH(UserLinksBasic.GRAPH_MODE_GRAPH, "Polyline", false),
    PIE_CHART(UserLinksBasic.GRAPH_MODE_PIE_CHART, "Pie chart", true),
    BARS(UserLinksBasic.GRAPH_MODE_BARS, "Bars", true),
    DISTRIBUTION(UserLinksBasic.GRAPH_MODE_DISTRIBUTION, "Distribution", true),
    HEATMAP(UserLinksBasic.GRAPH_MODE_HEATMAP, "Heatmap", true),
    // https://st.yandex-team.ru/SOLOMON-1665
    NONE(UserLinksBasic.GRAPH_MODE_NONE, "None", true),
    ;

    public final String value;
    private final String title;
    private final boolean canBeSecondary;

    GraphMode(String value, String title, boolean canBeSecondary) {
        this.value = value;
        this.title = title;
        this.canBeSecondary = canBeSecondary;
    }

    @Nonnull
    public static GraphMode parse(@Nullable String mode) {
        if (mode == null || mode.isEmpty()) {
            return GRAPH;
        }
        for (GraphMode graphMode : values()) {
            if (graphMode.value.equals(mode)) {
                return graphMode;
            }
        }

        throw new IllegalArgumentException("unknown graph mode: " + mode);
    }

    @Nonnull
    public static GraphSettingOption[] graphSettingOptions(boolean primary) {
        ArrayList<GraphSettingOption> r = new ArrayList<>();
        for (GraphMode graphMode : values()) {
            if (primary || graphMode.canBeSecondary) {
                r.add(graphMode.toGraphSettingOption());
            }
        }
        return r.toArray(new GraphSettingOption[0]);
    }

    public GraphSettingOption toGraphSettingOption() {
        return new GraphSettingOption(value, title);
    }

    public boolean needPoints() {
        switch (this) {
            case GRAPH:
                return true;
            default:
                return false;
        }
    }
}
