package ru.yandex.solomon.gateway.utils;

import java.util.Arrays;

import ru.yandex.solomon.util.time.DurationUtils;

/**
 * @author Stepan Koltsov
 */
public class Grids {

    private static int[] gridSeconds = {
        // seconds
        1,
        5,
        15,
        30,
        // minutes
        1 * 60,
        5 * 60,
        15 * 60,
        30 * 60,
        // hours
        1 * 3600,
        2 * 3600,
        4 * 3600,
        12 * 3600,
        // days
        1 * 86400,
        2 * 86400,
    };

    // note current combinators setup violates this rule
    static int[] allowedGridStepSeconds() {
        return gridSeconds.clone();
    }

    static boolean isValidGridStepSeconds(int seconds) {
        return Arrays.binarySearch(allowedGridStepSeconds(), seconds) >= 0;
    }

    public static long roundMillisUpToGrid(long millis) {
        return Arrays.stream(gridSeconds)
            .filter(step -> DurationUtils.secondsToMillis(step) >= millis)
            .mapToLong(DurationUtils::secondsToMillis)
            .findFirst()
            .orElse((millis + 1000) / 1000 * 1000);
    }
}
