package ru.yandex.solomon.gateway.utils;

import java.util.HashMap;
import java.util.Map;


/**
 * @author Stepan Koltsov
 */
public class UserLinks {

    private static final String LABEL_NAME_QA_PREFIX = "l.";


    /**
     * filters out params that are not prefixed with 'l.' and
     * removes that prefix from all the rest.
     */
    public static Map<String, String> cleanParams(Map<String, String> params) {
        Map<String, String> result = new HashMap<>(params.size());
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (e.getKey().startsWith(LABEL_NAME_QA_PREFIX)) {
                String name = e.getKey().substring(LABEL_NAME_QA_PREFIX.length());
                result.put(name, e.getValue());
            }
        }
        return result;
    }

}
