package ru.yandex.solomon.gateway.utils;

import javax.annotation.Nullable;

/**
 * @author Stepan Koltsov
 */
public class WwwBooleans {

    public static final String TRUE = "y";

    public static boolean isTrueOrPositive(@Nullable String s) {
        if (isTrue(s)) {
            return true;
        }
        if (s == null || s.isEmpty()) {
            return false;
        }
        char c = s.charAt(0);
        return c >= '0' && c <= '9';
    }

    public static boolean parseBooleanOr(@Nullable String s, boolean defaultValue) {
        return parseBoolean(s).isTrueOr(defaultValue);
    }

    public static OptionalBoolean parseBoolean(@Nullable String s) {
        if (isTrue(s)) {
            return OptionalBoolean.TRUE;
        } else if (isFalse(s)) {
            return OptionalBoolean.FALSE;
        } else {
            return OptionalBoolean.NONE;
        }
    }

    public static boolean isTrue(@Nullable String s) {
        if (s == null) {
            return false;
        }
        switch (s) {
            case "on":
            case "true":
            case "t":
            case "yes":
            case "y":
            case "1":
                return true;
            default:
                return false;
        }
    }

    public static boolean isFalse(@Nullable String s) {
        if (s == null) {
            return false;
        }
        switch (s) {
            case "off":
            case "false":
            case "f":
            case "no":
            case "n":
            case "0":
                return true;
            default:
                return false;
        }
    }

    public static String formatBoolean(boolean b) {
        return Boolean.toString(b);
    }

}
