package ru.yandex.solomon.gateway.utils.conf.source;

import ru.yandex.solomon.gateway.utils.GraphMode;
import ru.yandex.solomon.gateway.utils.UserLinksBasic;
import ru.yandex.solomon.gateway.utils.conf.GraphSetting;
import ru.yandex.solomon.gateway.utils.conf.GraphSettings;

/**
 * @author Stepan Koltsov
 */
public interface GraphSettingsSource {

    // nullable
    String getRaw(String name);

    static String getRawOrEmpty(GraphSettingsSource graphSettingsSource, String name) {
        String r = graphSettingsSource.getRaw(name);
        return r != null ? r : "";
    }

    static boolean isGradient(GraphSettingsSource graphSettingsSource) {
        return GraphSettingsSource.getRawOrEmpty(graphSettingsSource, UserLinksBasic.COLOR_SCHEME_QUERY_ARG).equals(UserLinksBasic.COLOR_SCHEME_GRADIENT);
    }

    default boolean isAnyGraphOfType(String type) {
        String[] options = new String[] { UserLinksBasic.GRAPH_MODE, UserLinksBasic.SECONDARY_GRAPH_MODE };
        for (String option : options) {
            if (getRawOrEmpty(this, option).equals(type)) {
                return true;
            }
        }

        return false;
    }

    static boolean isAnyGraphHeatmap(GraphSettingsSource graphSettingsSource) {
        return graphSettingsSource.isAnyGraphOfType(UserLinksBasic.GRAPH_MODE_HEATMAP);
    }

    static boolean isAnyGraphLines(GraphSettingsSource graphSettingsSource) {
        return graphSettingsSource.isAnyGraphOfType(UserLinksBasic.GRAPH_MODE_GRAPH);
    }

    static boolean isAnyGraphNeedPoints(GraphSettingsSource graphSettingsSource) {
        for (GraphSetting graphSetting : new GraphSetting[]{ GraphSettings.graphMode, GraphSettings.secondaryGraphMode }) {
            GraphMode graphMode = GraphMode.parse(graphSetting.getFromOrDefault(graphSettingsSource));
            if (graphMode.needPoints()) {
                return true;
            }
        }

        return false;
    }

    static boolean isOverLinesPercentile(GraphSettingsSource source) {
        String param = GraphSettingsSource.getRawOrEmpty(source, UserLinksBasic.OVER_LINES_TRANSFORM);
        return param.equals("PERCENTILE") || param.equals("WEIGHTED_PERCENTILE");
    }

}
