package ru.yandex.solomon.gateway.utils.conf.source;

/**
 * @author Stepan Koltsov
 */
public class GraphSettingsSourceSeq implements GraphSettingsSource {
    private final GraphSettingsSource[] sources;

    public GraphSettingsSourceSeq(GraphSettingsSource... sources) {
        this.sources = sources;
    }

    @Override
    public String getRaw(String name) {
        for (GraphSettingsSource source : sources) {
            String r = source.getRaw(name);
            if (r != null && r.length() > 0) {
                return r;
            }
        }
        return "";
    }
}
