package ru.yandex.solomon.gateway.utils.url;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class QueryArg {
    public final QueryArgNameOrValue name;
    public final QueryArgNameOrValue value;

    public QueryArg(QueryArgNameOrValue name, QueryArgNameOrValue value) {
        this.name = name;
        this.value = value;
    }

    @Nonnull
    public static QueryArg decoded(String name, String value) {
        return new QueryArg(QueryArgNameOrValue.decoded(name), QueryArgNameOrValue.decoded(value));
    }

    @Nonnull
    public static QueryArg encoded(String name, String value) {
        return new QueryArg(QueryArgNameOrValue.encoded(name), QueryArgNameOrValue.encoded(value));
    }

    @Nonnull
    public String reconstruct() {
        return name.encoded + "=" + value.encoded;
    }

    public void reconstructTo(StringBuilder sb) {
        sb.append(name.encoded);
        sb.append("=");
        sb.append(value.encoded);
    }

}
