package ru.yandex.solomon.gateway.utils.url;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class QueryArgNameOrValue {
    // lazily initialized
    @Nullable
    private String decodedLazy;
    @Nonnull
    public final String encoded;

    QueryArgNameOrValue(@Nullable String decoded, String encoded) {
        this.decodedLazy = decoded;
        this.encoded = encoded;
    }

    @Nonnull
    public String getDecoded() {
        if (decodedLazy == null) {
            decodedLazy = UrlUtils.decodeArg(encoded);
        }
        return decodedLazy;
    }

    @Nonnull
    public static QueryArgNameOrValue decoded(String decoded) {
        if (decoded == null) {
            throw new IllegalArgumentException("null");
        }
        return new QueryArgNameOrValue(decoded, UrlUtils.encodeArg(decoded));
    }

    @Nonnull
    public static QueryArgNameOrValue encoded(String encoded) {
        return new QueryArgNameOrValue(null, encoded);
    }

    public boolean isEmpty() {
        return encoded.isEmpty();
    }

    @Override
    public String toString() {
        return encoded;
    }
}
