package ru.yandex.solomon.gateway.viewHistory;

import ru.yandex.solomon.gateway.utils.UserLinksBasic;
import ru.yandex.solomon.gateway.utils.url.UrlParsed;
import ru.yandex.solomon.gateway.utils.url.UrlUtils;


/**
 * @author albazh
 */
class ViewHistoryUrlNormalizer {

    static String normalizeUrl(String url) {
        UrlParsed urlParsed = UrlUtils.parseUrl(url).removeQueryArgs(unpinnedQueryArgs);
        String normalizedUrl = ViewHistoryUrlUtils.sortQueryArgsByName(urlParsed).reconstruct();
        normalizedUrl = normalizedUrl.replaceAll("!", "%21");
        return normalizedUrl;
    }

    private static final String[] unpinnedQueryArgs = new String[]{
        UserLinksBasic.LABEL_NAME_QA_PREFIX,
        UserLinksBasic.NEED_POINTS_PARAM,
        UserLinksBasic.FORCE_HOST_PARAM,
        UserLinksBasic.FORCE_HOST_LOCAL_VALUE,
        UserLinksBasic.REVIVER_CLIENT_ID,
        UserLinksBasic.GRAPH_VALUE_AUTO,
        UserLinksBasic.SCALE_NATURAL,
        UserLinksBasic.SCALE_LOG,
        UserLinksBasic.COLOR_SCHEME_GRADIENT,
        UserLinksBasic.GRAPH_MODE_PIE_CHART,
        UserLinksBasic.GRAPH_MODE_BARS,
        UserLinksBasic.GRAPH_MODE_DISTRIBUTION,
        UserLinksBasic.GRAPH_MODE_HEATMAP,
        UserLinksBasic.GRAPH_MODE_NONE,
        UserLinksBasic.B_QA,
        UserLinksBasic.E_QA,
        UserLinksBasic.METADATA_VERSION_HASH_PARAM,
        UserLinksBasic.SOLOMON_CLIENT_VERSION,
        UserLinksBasic.SHOW_CENSORED_INTERVALS,
        UserLinksBasic.DATA_DELAY,
        UserLinksBasic.SENSORS,
        UserLinksBasic.SENSORS_DATA,
        UserLinksBasic.COUNT_USAGE,
        UserLinksBasic.CHART_BORDER_WIDTH,
        UserLinksBasic.DISTRIBUTION_MODE,
        UserLinksBasic.OVER_LINES_TRANSFORM,
        UserLinksBasic.SP_CLUSTER,
        UserLinksBasic.SP_BACKUP,
        UserLinksBasic.SP_ETERNITY_ONLY,
        UserLinksBasic.SP_SHARD,
        UserLinksBasic.MIN_DATAMIN,
        UserLinksBasic.FILTER,
        UserLinksBasic.FILTER_BY,
        UserLinksBasic.FILTER_LIMIT,
        UserLinksBasic.DOWNSAMPLING,
        UserLinksBasic.DOWNSAMPLING_AGGR,
        UserLinksBasic.GRID,
        UserLinksBasic.MAX_POINTS,
        UserLinksBasic.DOWNSAMPLING_PARAM_AUTO,
        UserLinksBasic.DOWNSAMPLING_PARAM_WITHOUT_GRID,
        UserLinksBasic.DOWNSAMPLING_PARAM_BY_INTERVAL,
        UserLinksBasic.DOWNSAMPLING_PARAM_BY_POINTS,
        UserLinksBasic.DOWNSAMPLING_PARAM_OFF,
        UserLinksBasic.DOWNSAMPLING_PARAM_RAW,
        UserLinksBasic.MOVING_WINDOW,
        UserLinksBasic.MOVING_PERCENTILE
    };
}
