package ru.yandex.solomon.gateway.www.ser;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;

import javax.annotation.Nonnull;

import ru.yandex.solomon.gateway.utils.ser.GggIntervalSerializer;
import ru.yandex.solomon.gateway.www.time.UiInstant;
import ru.yandex.solomon.gateway.www.time.UiInterval;
import ru.yandex.solomon.util.www.ser.WwwDurationSerializer;

/**
 * @author Stepan Koltsov
 */
public class WwwIntervalSerializer {

    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.of("Europe/Moscow");

    public static UiInterval parseInterval(String b, String e) {
        return UiInterval.between(
            buildUiInstantOrDefault(b, UiInstant.relativeBackwards(Duration.ofDays(GggIntervalSerializer.DEFAULT_BEGIN_OF_INTERVAL_IN_DAYS))),
            buildUiInstantOrDefault(e, UiInstant.now())
        );
    }

    private static UiInstant buildUiInstantOrDefault(String durationOrInstant, UiInstant defaultUiInstant) {
        if (durationOrInstant.isEmpty()) {
            return defaultUiInstant;
        }
        Optional<Duration> duration = WwwDurationSerializer.parseDuration(durationOrInstant);
        if (duration.isPresent()) {
            return UiInstant.relativeBackwards(duration.get().abs());
        }
        return UiInstant.instant(parseInstant(durationOrInstant));
    }

    private static LocalDateTime parseLocalDateTime(String s) {
        return LocalDateTime.parse(s.replace(' ', 'T'));
    }

    static Instant parseInstant(String e) {
        if (e.endsWith("Z")) {
            return Instant.parse(e.replace(' ', 'T'));
        } else {
            return parseLocalDateTime(e).atZone(DEFAULT_ZONE_ID).toInstant();
        }
    }

    static String instantToString(Instant instant) {
        return instant.toString();
    }

    public static String uiInstantToString(UiInstant uiInstant) {
        return uiInstant.dispatch(new UiInstant.Dispatch<String>() {
            @Override
            public String instant(@Nonnull Instant instant) {
                return instantToString(instant);
            }

            @Override
            public String relative(@Nonnull Duration relative) {
                return WwwDurationSerializer.formatDuration(relative);
            }
        });
    }
}
