package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.alert.gateway.dto.notificationChannel.NotificationChannelDto;
import ru.yandex.solomon.alert.protobuf.notification.TCloudEmailType;
import ru.yandex.solomon.alert.protobuf.notification.TCloudPushType;
import ru.yandex.solomon.alert.protobuf.notification.TCloudSmsType;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * @author Ivan Tsybulin
 */
@RunWith(Parameterized.class)
public class NotificationChannelDtoTest {
    @Parameterized.Parameter
    public TNotification.TypeCase type;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object> data() {
        return Arrays.asList(
            TNotification.TypeCase.CLOUDEMAIL,
            TNotification.TypeCase.CLOUDSMS,
            TNotification.TypeCase.CLOUDPUSH
        );
    }

    @Test
    public void protoDtoAndBack() {
        TNotification source = randomCloudNotification(type);
        NotificationChannelDto dto = NotificationChannelDto.fromProto(source);
        TNotification restoreProto = dto.toProto();

        assertThat(restoreProto, equalTo(source));
    }

    private static TNotification randomCloudNotification(TNotification.TypeCase type) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        var builder = TNotification.newBuilder()
            .setDefaultForProject(ThreadLocalRandom.current().nextBoolean())
            .setCreatedAt(random.nextLong(1_500_000_000_000L, 2_000_000_000_000L))
            .setUpdatedAt(random.nextLong(1_500_000_000_000L, 2_000_000_000_000L));

        List<String> recipients = new ArrayList<>(5);
        for (int i = 0; i < random.nextInt(1, 5); i++) {
            recipients.add(RandomStringUtils.randomAlphanumeric(10));
        }

        switch (type) {
            case CLOUDEMAIL -> {
                var email = TCloudEmailType.newBuilder();
                email.addAllRecipients(recipients);
                builder.setCloudEmail(email);
            }
            case CLOUDSMS -> {
                var sms = TCloudSmsType.newBuilder();
                sms.addAllRecipients(recipients);
                builder.setCloudSms(sms);
            }
            case CLOUDPUSH -> {
                var push = TCloudPushType.newBuilder();
                push.addAllRecipients(recipients);
                builder.setCloudPush(push);
            }
            default -> throw new IllegalStateException("Case " + type + " not covered");
        }
        return builder.build();
    }
}
