package ru.yandex.solomon.gateway.api.internal;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProjectSettingsValidatorTest {

    @Test
    public void knownKey() {
        ProjectSettingsValidator.KNOWN_KEYS.forEach(ProjectSettingsValidator::validateKey);
    }

    @Test(expected = BadRequestException.class)
    public void unknownKey() {
        ProjectSettingsValidator.validateKey("unknownProjectSetting");
    }

    @Test
    public void validBoolSetting() {
        ProjectSettingsValidator.validateSetting("disableMenuConvert", "true");
        ProjectSettingsValidator.validateSetting("disableMenuConvert", "false");
        ProjectSettingsValidator.validateSetting("disableMenuConvert", "");
    }

    @Test(expected = BadRequestException.class)
    public void notValidBoolSetting() {
        ProjectSettingsValidator.validateSetting("disableMenuConvert", "str");
    }
}
