package ru.yandex.solomon.gateway.api.internal;

import org.junit.Test;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
public class UserSettingsValidatorTest {

    @Test
    public void knownKey() {
        UserSettingKeys.KNOWN_KEYS.forEach(UserSettingsValidator::validateKey);
    }

    @Test(expected = BadRequestException.class)
    public void unknownKey() {
        UserSettingsValidator.validateKey("unknownSetting");
    }

    @Test
    public void validBoolSetting() {
        UserSettingsValidator.validateSetting("redirectToNewUi", "true");
        UserSettingsValidator.validateSetting("redirectToNewUi", "false");
        UserSettingsValidator.validateSetting("redirectToNewUi", "");
    }

    @Test(expected = BadRequestException.class)
    public void notValidBoolSetting() {
        UserSettingsValidator.validateSetting("redirectToNewUi", "user");
    }
}
