package ru.yandex.solomon.gateway.api.internal;

import java.time.Duration;
import java.time.Instant;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Assert;
import org.junit.Ignore;

import ru.yandex.monitoring.gateway.DataQuery;
import ru.yandex.solomon.expression.analytics.Program;
import ru.yandex.solomon.expression.version.SelVersion;
import ru.yandex.solomon.gateway.api.internal.yasm.RequestConverter;
import ru.yandex.solomon.gateway.data.DataRequest;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YasmGatewayServiceImplTest {
    @Ignore
    public void dispatchHostOrGroup() {
        var metagroupReq = RequestConverter.makeDataClientRequest(makeQuery("ASEARCH")).join();
        var groupReq = RequestConverter.makeDataClientRequest(makeQuery("VLA.042")).join();
        var hostReq = RequestConverter.makeDataClientRequest(makeQuery("sas1-0547")).join();

        Assert.assertTrue(isGroupReq(metagroupReq));
        Assert.assertTrue(isGroupReq(groupReq));
        Assert.assertFalse(isGroupReq(hostReq));
    }

    private static DataQuery makeQuery(String hosts) {
        Instant now = Instant.now();
        return DataQuery.newBuilder()
                .setHosts(hosts)
                .setFromMillis(now.minus(Duration.ofMinutes(5)).toEpochMilli())
                .setToMillis(now.toEpochMilli())
                .setGridMillis(5_000)
                .setExpression("hcount(counter-instance_hgram)")
                .setTags("itype=yasmagent;ctype=prod")
                .build();
    }

    private boolean isGroupReq(DataRequest request) {
        return Program.fromSourceWithReturn(SelVersion.HISTOGRAM_FUNCTIONS_DONT_MERGE_3, request.getProgram(), false)
                .compile()
                .prepare(Interval.before(Instant.now(), Duration.ofHours(1)))
                .getLoadRequests()
                .stream()
                .findFirst()
                .orElseThrow()
                .getSelectors()
                .findByKey("cluster")
                .getValue()
                .startsWith("group_");
    }
}
