package ru.yandex.solomon.gateway.api.old.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Oleg Baryshnikov
 */
public class MetricCombinerTest {

    @Test
    public void empty() {
        test(Labels.of(), Set.of(Labels.of()));
    }

    @Test
    public void one() {
        test(
            Labels.of("code", "500"),
            Set.of(
                Labels.of("code", "500"),
                Labels.of("code", "total")
            ));
    }

    @Test
    public void withTotal() {
        // We must avoid to use "total" in labels
        test(
            Labels.of("name", "total"),
            List.of(
                Labels.of("name", "total"),
                Labels.of("name", "total")
            ));
    }

    @Test
    public void two() {
        test(
            Labels.of("code", "500", "handler", "data_api"),
            Set.of(
                Labels.of("code", "500", "handler", "data_api"),
                Labels.of("code", "total", "handler", "data_api"),
                Labels.of("code", "500", "handler", "total"),
                Labels.of("code", "total", "handler", "total")
            ));
    }

    @Test
    public void three() {
        test(
            Labels.of("code", "500", "handler", "data_api", "contentType", "json"),
            Set.of(
                Labels.of("code", "500", "handler", "data_api", "contentType", "json"),
                Labels.of("code", "total", "handler", "data_api", "contentType", "json"),
                Labels.of("code", "500", "handler", "total", "contentType", "json"),
                Labels.of("code", "total", "handler", "total", "contentType", "json"),
                Labels.of("code", "500", "handler", "data_api", "contentType", "total"),
                Labels.of("code", "total", "handler", "data_api", "contentType", "total"),
                Labels.of("code", "500", "handler", "total", "contentType", "total"),
                Labels.of("code", "total", "handler", "total", "contentType", "total")
            ));
    }

    private static void test(Labels labels, Set<Labels> expectedLabels) {
        List<Labels> actualLabels = new ArrayList<>(expectedLabels.size());
        MetricCombiner.registerWithAllTotals(labels, actualLabels::add);
        // Need to check duplicates
        Assert.assertEquals(expectedLabels.size(), actualLabels.size());
        Assert.assertEquals(expectedLabels, Set.copyOf(actualLabels));
    }

    private static void test(Labels labels, List<Labels> expectedLabels) {
        List<Labels> actualLabels = new ArrayList<>(expectedLabels.size());
        MetricCombiner.registerWithAllTotals(labels, actualLabels::add);
        Assert.assertEquals(expectedLabels, actualLabels);
    }
}
