package ru.yandex.solomon.gateway.api.staffOnly;

import java.util.HashSet;
import java.util.Set;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class LinksRepairTest {

    @Test
    public void regexpPredicate() {
        Set<String> knownAddresses = new HashSet<>();
        knownAddresses.add("stockpile-a-2.mon.yandexcloud.co.il:4500");
        knownAddresses.add("alerting-55885b48d7-z2mb9.alerting-service.solomon-testing.svc.sas.local:4530");
        knownAddresses.add("test-alerting-sas-00.mon.yandex.net:4530");

        var repair = LinksRepair.regexpPredicate("https?://([0-9a-zA-Z\\._-]+:\\d+)/", "/staffOnly/$1/",
                matchResult -> knownAddresses.contains(matchResult.group(1)));

        assertEquals("a", repair.repair("a", "localhost"));
        assertEquals("link to /staffOnly/stockpile-a-2.mon.yandexcloud.co.il:4500/local-shards url",
                repair.repair("link to http://stockpile-a-2.mon.yandexcloud.co.il:4500/local-shards url", "localhost"));
        assertEquals("link to http://stockpile-b-2.mon.yandexcloud.co.il:4500/local-shards url",
                repair.repair("link to http://stockpile-b-2.mon.yandexcloud.co.il:4500/local-shards url", "localhost"));

        assertEquals("/staffOnly/alerting-55885b48d7-z2mb9.alerting-service.solomon-testing.svc.sas.local:4530/internal",
                repair.repair("http://alerting-55885b48d7-z2mb9.alerting-service.solomon-testing.svc.sas.local:4530/internal", "localhost"));

        assertEquals("<a href=\"/staffOnly/test-alerting-sas-00.mon.yandex.net:4530/local-shards\">test-alerting-sas-00</a>",
                repair.repair("<a href=\"http://test-alerting-sas-00.mon.yandex.net:4530/local-shards\">test-alerting-sas-00</a>", "localhost"));
    }
}
