package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.function.Consumer;

import org.junit.Test;

import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.DecimPolicy;
import ru.yandex.solomon.core.db.model.ShardSettings;
import ru.yandex.solomon.util.collection.Nullables;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;

/**
 * @author Alexey Trushkin
 */
public class ClusterDtoTest {

    @Test
    public void clusterPushTest() {
        ClusterDto dto = clusterUnspecified();
        Cluster cluster = ClusterDto.toModel(dto);
        assertEquals(ShardSettings.Type.UNSPECIFIED, cluster.getShardSettings().getType());
        assertNull(cluster.getShardSettings().getPullSettings());
        assertEquals(0, cluster.getShardSettings().getGrid());
        assertEquals(0, cluster.getShardSettings().getInterval());
        assertEquals(ShardSettings.AggregationSettings.EMPTY, cluster.getShardSettings().getAggregationSettings());
        assertEquals(dto.getSensorsTtlDays(), Integer.valueOf(cluster.getShardSettings().getMetricsTtl()));
        assertEquals(DecimPolicy.UNDEFINED, cluster.getShardSettings().getRetentionPolicy());
    }

    @Test
    public void clusterPullTest() {
        assertDto((dto) -> dto.setPort(11));
        assertDto((dto) -> dto.setTvmDestId("11"));
        assertDto((dto) -> dto.setUseFqdn(true));
        assertDto((dto) -> dto.setHosts(new ClusterHosts.PatternDto[]{new ClusterHosts.PatternDto()}));
        assertDto((dto) -> dto.setHostUrls(new ClusterHosts.UrlDto[]{new ClusterHosts.UrlDto()}));
        assertDto((dto) -> dto.setConductorGroups(new ClusterHosts.ConductorGroupDto[]{new ClusterHosts.ConductorGroupDto()}));
        assertDto((dto) -> dto.setConductorTags(new ClusterHosts.ConductorTagDto[]{new ClusterHosts.ConductorTagDto()}));
        assertDto((dto) -> dto.setNannyGroups(new ClusterHosts.NannyGroupDto[]{new ClusterHosts.NannyGroupDto()}));
        assertDto((dto) -> dto.setQloudGroups(new ClusterHosts.QloudGroupDto[]{new ClusterHosts.QloudGroupDto()}));
        assertDto((dto) -> dto.setNetworks(new ClusterHosts.NetworkDto[]{new ClusterHosts.NetworkDto()}));
        assertDto((dto) -> dto.setYpClusters(new ClusterHosts.YpDto[]{new ClusterHosts.YpDto()}));
        assertDto((dto) -> dto.setInstanceGroups(new ClusterHosts.InstanceGroupDto[]{new ClusterHosts.InstanceGroupDto()}));
        assertDto((dto) -> dto.setCloudDns(new ClusterHosts.CloudDnsDto[]{new ClusterHosts.CloudDnsDto()}));
        assertDto((dto) -> {
            dto.setUseFqdn(true);
            dto.setInstanceGroups(new ClusterHosts.InstanceGroupDto[]{new ClusterHosts.InstanceGroupDto()});
        });
    }

    private void assertDto(Consumer<ClusterDto> change) {
        ClusterDto dto = clusterUnspecified();
        change.accept(dto);
        Cluster cluster = ClusterDto.toModel(dto);
        assertEquals(ShardSettings.Type.PULL, cluster.getShardSettings().getType());
        assertEquals(Integer.valueOf(Nullables.orZero(dto.getPort())), Integer.valueOf(cluster.getShardSettings().getPullSettings().getPort()));
        assertEquals(Nullables.orEmpty(dto.getTvmDestId()), cluster.getShardSettings().getPullSettings().getTvmDestinationId());
        assertFalse(cluster.getShardSettings().getPullSettings().isAddTsArgs());
        assertEquals("", cluster.getShardSettings().getPullSettings().getPath());
        assertEquals(Nullables.orFalse(dto.getUseFqdn()) ? ShardSettings.HostLabelPolicy.FULL_HOSTNAME : ShardSettings.HostLabelPolicy.SHORT_HOSTNAME, cluster.getShardSettings().getPullSettings().getHostLabelPolicy());
        assertEquals(0, cluster.getShardSettings().getGrid());
        assertEquals(0, cluster.getShardSettings().getInterval());
        assertEquals(ShardSettings.AggregationSettings.EMPTY, cluster.getShardSettings().getAggregationSettings());
        assertEquals(dto.getSensorsTtlDays(), Integer.valueOf(cluster.getShardSettings().getMetricsTtl()));
        assertEquals(DecimPolicy.UNDEFINED, cluster.getShardSettings().getRetentionPolicy());
    }

    private ClusterDto clusterUnspecified() {
        ClusterDto dto = new ClusterDto();
        dto.setProjectId("myProjectId");
        dto.setId("myId");
        dto.setName("name");
        dto.setSensorsTtlDays(123);
        return dto;
    }
}
