package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.Collections;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MenuItemDtoTest {

    @Test
    public void validate() throws Exception {
        assertNotValid(leaf("", ""));
        assertNotValid(leaf("", "/?project=solomon"));
        assertNotValid(leaf("title", ""));
        assertNotValid(leaf("title {{host}}", "/?path={{path}}"));
        assertNotValid(leaf("title {{host}}", "/?project=solomon"));
        assertNotValid(leaf("title", "/?host={{host}}"));
        assertNotValid(tree("title"));
        assertNotValid(tree("title", leaf("title2", "/?host={{host}}")));
        assertNotValid(tree("title", tree("title2", leaf("title2", "/?host={{host}}"))));

        assertValid(leaf("title", "/?project=solomon"));
        assertValid(leaf("title {{host}}", "/?project=solomon", "host=*"));
        assertValid(leaf("title", "/?host={{host}}", "host=*"));
        assertValid(leaf("title {{host}}", "/?host={{host}}", "host=*"));
        assertValid(leaf("title {{host}}", "/?path={{path}}", "host=*&path=*"));
        assertValid(tree("title", "host=*", leaf("title2", "/?host={{host}}")));
        assertValid(tree("title", "path=*", tree("title2", leaf("title", "/?path={{path}}"))));
    }

    public static MenuItemDto leaf(String title, String url) {
        MenuItemDto dto = new MenuItemDto();
        dto.setTitle(title);
        dto.setUrl(url);
        return dto;
    }

    private static void assertNotValid(MenuItemDto dto) {
        assertNotValid(dto, Collections.emptyMap());
    }

    private static void assertNotValid(MenuItemDto dto, Map<String, String> restrictions) {
        try {
            dto.validate(restrictions);
        } catch (BadRequestException e) {
            return;
        }
        throw new AssertionError("menu item must not be valid");
    }

    private static void assertValid(MenuItemDto dto) {
        assertValid(dto, Collections.emptyMap());
    }

    private static void assertValid(MenuItemDto dto, Map<String, String> restrictions) {
        try {
            dto.validate(restrictions);
        } catch (BadRequestException e) {
            throw new AssertionError("menu item is not valid", e);
        }
    }

    private static MenuItemDto leaf(String title, String url, String selectors) {
        MenuItemDto dto = leaf(title, url);
        dto.setSelectors(selectors);
        return dto;
    }

    private static MenuItemDto tree(String title, MenuItemDto... subMenuItems) {
        MenuItemDto dto = new MenuItemDto();
        dto.setTitle(title);
        dto.setChildren(subMenuItems);
        return dto;
    }

    private static MenuItemDto tree(String title, String selectors, MenuItemDto... subMenuItems) {
        MenuItemDto dto = tree(title, subMenuItems);
        dto.setSelectors(selectors);
        return dto;
    }
}
