package ru.yandex.solomon.gateway.api.v2.dto;

import org.junit.Test;

import ru.yandex.solomon.core.db.model.ClusterServiceNames;
import ru.yandex.solomon.core.db.model.DecimPolicy;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.core.db.model.ShardSettings;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

/**
 * @author Alexey Trushkin
 */
public class ShardDtoTest {

    @Test
    public void shardTest() {
        ShardDto dto = shard();
        Shard shard = ShardDto.toModel(dto, new ClusterServiceNames("a", "b"));
        assertEquals(ShardSettings.Type.UNSPECIFIED, shard.getShardSettings().getType());
        assertNull(shard.getShardSettings().getPullSettings());
        assertEquals(0, shard.getShardSettings().getGrid());
        assertEquals(0, shard.getShardSettings().getInterval());
        assertEquals(ShardSettings.AggregationSettings.EMPTY, shard.getShardSettings().getAggregationSettings());
        assertEquals(dto.getSensorsTtlDays(), Integer.valueOf(shard.getShardSettings().getMetricsTtl()));
        assertEquals(DecimPolicy.POLICY_KEEP_FOREVER, shard.getShardSettings().getRetentionPolicy());
    }

    private ShardDto shard() {
        ShardDto dto = new ShardDto();
        dto.setProjectId("myProjectId");
        dto.setId("myId");
        dto.setClusterId("cid");
        dto.setServiceId("sid");
        dto.setDecimPolicy(DecimPolicy.POLICY_KEEP_FOREVER);
        dto.setSensorsTtlDays(123);
        return dto;
    }

}
