package ru.yandex.solomon.gateway.api.v2.dto;

import java.time.Instant;

import org.junit.Test;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
public class ValidationUtilsTest {

    @Test(expected = BadRequestException.class)
    public void validateZeroInterval() {
        ValidationUtils.validateInterval(
            Instant.parse("2018-08-17T00:00:00Z"),
            Instant.parse("2018-08-17T00:00:00Z")
        );
    }

    @Test(expected = BadRequestException.class)
    public void validateLongInterval() {
        ValidationUtils.validateInterval(
            Instant.parse("2018-08-17T00:00:00Z"),
            Instant.parse("2038-08-17T00:00:00Z")
        );
    }

    @Test(expected = BadRequestException.class)
    public void validateNegativeInterval() {
        ValidationUtils.validateInterval(
            Instant.parse("2038-08-16T00:00:00Z"),
            Instant.parse("2018-08-17T00:00:00Z")
        );
    }

    @Test(expected = BadRequestException.class)
    public void validateShardMetricNameLabel() {
        ValidationUtils.validateMetricNameLabel("project");
    }

    @Test(expected = BadRequestException.class)
    public void validateInvalidMetricNameLabel() {
        ValidationUtils.validateMetricNameLabel("sensor*");
    }
}
