package ru.yandex.solomon.gateway.api.v3;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.gateway.api.v3.cloud.priv.dto.CloudDashboardDtoConverter;

import static org.junit.Assert.assertEquals;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.createPrivateModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.createPublicModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.dashboard;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.deletePrivateModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.deletePublicModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.getPrivateModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.getPublicModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.listModelResponse;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.listPrivateModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.listPublicModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.updatePrivateModel;
import static ru.yandex.solomon.gateway.api.v3.DashboardModelFactory.updatePublicModel;


/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class DashboardCompatibilityTest {

    private ru.yandex.solomon.gateway.api.v3.cloud.dto.CloudDashboardDtoConverter converter = new ru.yandex.solomon.gateway.api.v3.cloud.dto.CloudDashboardDtoConverter();
    private CloudDashboardDtoConverter converterPriv = new CloudDashboardDtoConverter();

    @Test
    public void getPublicToIntranet() {
        var request = getPublicModel();
        var intranetRequest = converter.convertToIntranet(request);
        var request2 = converter.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void getPrivateToIntranet() {
        var request = getPrivateModel();
        var intranetRequest = converterPriv.convertToIntranet(request);
        var request2 = converterPriv.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void listPublicToIntranet() {
        var request = listPublicModel();
        var intranetRequest = converter.convertToIntranet(request);
        var request2 = converter.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void listPrivateToIntranet() {
        var request = listPrivateModel();
        var intranetRequest = converterPriv.convertToIntranet(request);
        var request2 = converterPriv.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void listResponseIntranetToPublic() {
        var response = listModelResponse(true);
        var cloudResponse = converter.convertFromIntranet(response);
        var response2 = converter.convertToIntranet(cloudResponse);
        assertEquals(response2, response);
    }

    @Test
    public void listResponseIntranetToPrivate() {
        var response = listModelResponse(false);
        var cloudResponse = converterPriv.convertFromIntranet(response);
        var response2 = converterPriv.convertToIntranet(cloudResponse);
        assertEquals(response2, response);
    }

    @Test
    public void createPublicToIntranet() {
        var request = createPublicModel();
        var intranetRequest = converter.convertToIntranet(request);
        var request2 = converter.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void createPrivateToIntranet() {
        var request = createPrivateModel();
        var intranetRequest = converterPriv.convertToIntranet(request);
        var request2 = converterPriv.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void updatePublicToIntranet() {
        var request = updatePublicModel();
        var intranetRequest = converter.convertToIntranet(request);
        var request2 = converter.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void updatePrivateToIntranet() {
        var request = updatePrivateModel();
        var intranetRequest = converterPriv.convertToIntranet(request);
        var request2 = converterPriv.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void deletePublicToIntranet() {
        var request = deletePublicModel();
        var intranetRequest = converter.convertToIntranet(request);
        var request2 = converter.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void deletePrivateToIntranet() {
        var request = deletePrivateModel();
        var intranetRequest = converterPriv.convertToIntranet(request);
        var request2 = converterPriv.convertFromIntranet(intranetRequest);
        assertEquals(request2, request);
    }

    @Test
    public void dashboardToPublic() {
        var response = dashboard(true);
        var cloudResponse = converter.convertFromIntranet(response);
        var response2 = converter.convertToIntranet(cloudResponse);
        assertEquals(response2, response);
    }

    @Test
    public void dashboardToPrivate() {
        var response = dashboard(false);
        var cloudResponse = converterPriv.convertFromIntranet(response);
        var response2 = converterPriv.convertToIntranet(cloudResponse);
        assertEquals(response2, response);
    }
}
