package ru.yandex.solomon.gateway.api.v3;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.Timestamps;
import yandex.cloud.api.monitoring.v3.DashboardOuterClass;
import yandex.cloud.api.monitoring.v3.DashboardServiceOuterClass;

import ru.yandex.monitoring.api.v3.AlertWidget;
import ru.yandex.monitoring.api.v3.ChartWidget;
import ru.yandex.monitoring.api.v3.CustomParameter;
import ru.yandex.monitoring.api.v3.Dashboard;
import ru.yandex.monitoring.api.v3.DoubleParameter;
import ru.yandex.monitoring.api.v3.Downsampling;
import ru.yandex.monitoring.api.v3.EvaluationStatus;
import ru.yandex.monitoring.api.v3.IframeWidget;
import ru.yandex.monitoring.api.v3.IntegerParameter;
import ru.yandex.monitoring.api.v3.LabelValuesParameter;
import ru.yandex.monitoring.api.v3.ListDashboardsResponse;
import ru.yandex.monitoring.api.v3.Parameter;
import ru.yandex.monitoring.api.v3.Parametrization;
import ru.yandex.monitoring.api.v3.TextParameter;
import ru.yandex.monitoring.api.v3.TextWidget;
import ru.yandex.monitoring.api.v3.TitleWidget;
import ru.yandex.monitoring.api.v3.UnitFormat;
import ru.yandex.monitoring.api.v3.Widget;
import ru.yandex.solomon.conf.db3.ydb.Entity;
import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.util.Proto;

/**
 * @author Alexey Trushkin
 */
public class DashboardModelFactory {

    public static DashboardServiceOuterClass.GetDashboardRequest getPublicModel() {
        return DashboardServiceOuterClass.GetDashboardRequest.newBuilder()
                .setDashboardId("id")
                .build();
    }

    public static yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.GetDashboardRequest getPrivateModel() {
        return yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.GetDashboardRequest.newBuilder()
                .setDashboardId("id")
                .build();
    }

    public static DashboardServiceOuterClass.DeleteDashboardRequest deletePublicModel() {
        return DashboardServiceOuterClass.DeleteDashboardRequest.newBuilder()
                .setDashboardId("id")
                .setEtag("etag")
                .build();
    }

    public static yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.DeleteDashboardRequest deletePrivateModel() {
        return yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.DeleteDashboardRequest.newBuilder()
                .setDashboardId("id")
                .setEtag("etag")
                .build();
    }

    public static DashboardServiceOuterClass.ListDashboardsRequest listPublicModel() {
        return DashboardServiceOuterClass.ListDashboardsRequest.newBuilder()
                .setFolderId("folderId")
                .setPageSize(11)
                .setPageToken("123")
                .setFilter("someFilter")
                .build();
    }

    public static yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.ListDashboardsRequest listPrivateModel() {
        return yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.ListDashboardsRequest.newBuilder()
                .setFolderId("folderId")
                .setPageSize(11)
                .setPageToken("123")
                .setFilter("someFilter")
                .build();
    }

    public static DashboardServiceOuterClass.CreateDashboardRequest createPublicModel() {
        return DashboardServiceOuterClass.CreateDashboardRequest.newBuilder()
                .setFolderId("folderId")
                .setName(UUID.randomUUID().toString())
                .setDescription(UUID.randomUUID().toString())
                .setTitle(UUID.randomUUID().toString())
                .putAllLabels(Map.of("1", "2"))
                .addAllWidgets(dashboardPublic().getWidgetsList())
                .setParametrization(dashboardPublic().getParametrization())
                .build();
    }

    public static yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.CreateDashboardRequest createPrivateModel() {
        return yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.CreateDashboardRequest.newBuilder()
                .setFolderId("folderId")
                .setName(UUID.randomUUID().toString())
                .setDescription(UUID.randomUUID().toString())
                .setTitle(UUID.randomUUID().toString())
                .putAllLabels(Map.of("1", "2"))
                .addAllWidgets(dashboardPrivate().getWidgetsList())
                .setParametrization(dashboardPrivate().getParametrization())
                .build();
    }

    public static DashboardServiceOuterClass.UpdateDashboardRequest updatePublicModel() {
        return DashboardServiceOuterClass.UpdateDashboardRequest.newBuilder()
                .setDashboardId(UUID.randomUUID().toString())
                .setName(UUID.randomUUID().toString())
                .setDescription(UUID.randomUUID().toString())
                .setTitle(UUID.randomUUID().toString())
                .setEtag(UUID.randomUUID().toString())
                .putAllLabels(Map.of("1", "2"))
                .addAllWidgets(dashboardPublic().getWidgetsList())
                .setParametrization(dashboardPublic().getParametrization())
                .build();
    }

    public static yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.UpdateDashboardRequest updatePrivateModel() {
        return yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass.UpdateDashboardRequest.newBuilder()
                .setDashboardId(UUID.randomUUID().toString())
                .setName(UUID.randomUUID().toString())
                .setDescription(UUID.randomUUID().toString())
                .setTitle(UUID.randomUUID().toString())
                .setEtag(UUID.randomUUID().toString())
                .putAllLabels(Map.of("1", "2"))
                .addAllWidgets(dashboardPrivate().getWidgetsList())
                .setParametrization(dashboardPrivate().getParametrization())
                .build();
    }

    public static ListDashboardsResponse listModelResponse(boolean isPublic) {
        return ListDashboardsResponse.newBuilder()
                .setNextPageToken("next")
                .addAllDashboards(getDashboards(isPublic))
                .build();
    }

    private static Iterable<? extends Dashboard> getDashboards(boolean isPublic) {
        return List.of(
                dashboard(isPublic)
        );
    }

    public static DashboardOuterClass.Dashboard dashboardPublic() {
        try {
            return DashboardOuterClass.Dashboard.parseFrom(dashboard(true).toByteArray());
        } catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static yandex.cloud.priv.monitoring.v3.DashboardOuterClass.Dashboard dashboardPrivate() {
        try {
            return yandex.cloud.priv.monitoring.v3.DashboardOuterClass.Dashboard.parseFrom(dashboard(true).toByteArray());
        } catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static Dashboard dashboard(boolean isPublic) {
        return Dashboard.newBuilder()
                .setId("id")
                .setFolderId("folderId")
                .setCreatedAt(Timestamps.fromMillis(10000))
                .setModifiedAt(Timestamps.fromMillis(10002))
                .setCreatedBy("creator")
                .setModifiedBy("modifier")
                .setName("localId")
                .setDescription("descr")
                .putAllLabels(Map.of("1", "2"))
                .setTitle("title")
                .setEtag("123")
                .setParametrization(Parametrization.newBuilder()
                        .setSelectors("a='b'")
                        .addAllParameters(List.of(
                                Parameter.newBuilder()
                                        .setName("1")
                                        .setTitle("2")
                                        .setHidden(true)
                                        .setDescription("3")
                                        .setLabelValues(LabelValuesParameter.newBuilder()
                                                .setFolderId("folderId")
                                                .setSelectors("a='bc'")
                                                .setLabelKey("key")
                                                .setMultiselectable(true)
                                                .addAllDefaultValues(List.of("1", "2", "3"))
                                                .buildPartial())
                                        .build(),
                                Parameter.newBuilder()
                                        .setName("12")
                                        .setCustom(CustomParameter.newBuilder()
                                                .addAllValues(List.of("1", "2", "3"))
                                                .setMultiselectable(true)
                                                .addAllDefaultValues(List.of("1", "2", "3", "4"))
                                                .build())
                                        .build(),
                                Parameter.newBuilder()
                                        .setName("13")
                                        .setText(TextParameter.newBuilder()
                                                .setDefaultValue("textValue")
                                                .build())
                                        .build(),
                                Parameter.newBuilder()
                                        .setName("14")
                                        .setIntegerParameter(IntegerParameter.newBuilder()
                                                .setDefaultValue(1)
                                                .build())
                                        .build(),
                                Parameter.newBuilder()
                                        .setName("15")
                                        .setDoubleParameter(DoubleParameter.newBuilder()
                                                .setDefaultValue(1.123)
                                                .build())
                                        .build()
                        ))
                        .build())
                .addAllWidgets(isPublic
                                ? List.of(
                        text(),
                        title(),
                        chart(),
                        chartInterval(),
                        chartPoints(),
                        chart2()
                        )
                                : List.of(
                        text(),
                        title(),
                        alert(),
                        iframe(),
                        chart(),
                        chartInterval(),
                        chartPoints(),
                        chart2()
                        )
                )
                .build();
    }

    private static Widget chart() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setChart(ChartWidget.newBuilder()
                        .setId(UUID.randomUUID().toString())
                        .setQueries(ChartWidget.Queries.newBuilder()
                                .addAllTargets(List.of(
                                        ChartWidget.Queries.Target.newBuilder()
                                                .setQuery(UUID.randomUUID().toString())
                                                .setTextMode(true)
                                                .setHidden(true)
                                                .build()
                                ))
                                .setDownsampling(Downsampling.newBuilder()
                                        .setDisabled(true)
                                        .setGridAggregationValue(ThreadLocalRandom.current().nextInt(6))
                                        .setGapFillingValue(ThreadLocalRandom.current().nextInt(3))
                                        .build())
                                .build())
                        .addAllSeriesOverrides(List.of(
                                ChartWidget.SeriesOverrides.newBuilder()
                                        .setName(UUID.randomUUID().toString())
                                        .setSettings(ChartWidget.SeriesOverrides.SeriesOverrideSettings.newBuilder().build())
                                        .build(),
                                ChartWidget.SeriesOverrides.newBuilder()
                                        .setTargetIndex(UUID.randomUUID().toString())
                                        .setSettings(ChartWidget.SeriesOverrides.SeriesOverrideSettings.newBuilder()
                                                .setName(UUID.randomUUID().toString())
                                                .setColor(UUID.randomUUID().toString())
                                                .setTypeValue(ThreadLocalRandom.current().nextInt(4))
                                                .setStackName(UUID.randomUUID().toString())
                                                .setGrowDown(true)
                                                .setYaxisPositionValue(ThreadLocalRandom.current().nextInt(2))
                                                .build())
                                        .build()
                        ))
                        .setNameHidingSettings(ChartWidget.NameHidingSettings.newBuilder()
                                .setPositive(true)
                                .addAllNames(List.of(UUID.randomUUID().toString()))
                                .build())
                        .setDescription(UUID.randomUUID().toString())
                        .setTitle(UUID.randomUUID().toString())
                        .setDisplayLegend(true)
                        .setFreezeValue(ThreadLocalRandom.current().nextInt(4))
                        .setVisualizationSettings(ChartWidget.VisualizationSettings.newBuilder()
                                .setTypeValue(ThreadLocalRandom.current().nextInt(ChartWidget.VisualizationSettings.VisualizationType.values().length))
                                .setNormalize(true)
                                .setInterpolateValue(ThreadLocalRandom.current().nextInt(ChartWidget.VisualizationSettings.Interpolate.values().length))
                                .setAggregationValue(ThreadLocalRandom.current().nextInt(ChartWidget.VisualizationSettings.SeriesAggregation.values().length))
                                .setColorSchemeSettings(ChartWidget.VisualizationSettings.ColorSchemeSettings.newBuilder()
                                        .setGradient(ChartWidget.VisualizationSettings.ColorSchemeSettings.GradientColorScheme.newBuilder()
                                                .setGreenValue(UUID.randomUUID().toString())
                                                .setYellowValue(UUID.randomUUID().toString())
                                                .setRedValue(UUID.randomUUID().toString())
                                                .setVioletValue(UUID.randomUUID().toString())
                                                .build())
                                        .build())
                                .setHeatmapSettings(ChartWidget.VisualizationSettings.HeatmapSettings.newBuilder()
                                        .setGreenValue(UUID.randomUUID().toString())
                                        .setYellowValue(UUID.randomUUID().toString())
                                        .setRedValue(UUID.randomUUID().toString())
                                        .setVioletValue(UUID.randomUUID().toString())
                                        .build())
                                .setTitle(UUID.randomUUID().toString())
                                .setShowLabels(true)
                                .setYaxisSettings(ChartWidget.VisualizationSettings.YaxisSettings.newBuilder()
                                        .setLeft(ChartWidget.VisualizationSettings.Yaxis.newBuilder()
                                                .setTypeValue(ThreadLocalRandom.current().nextInt(ChartWidget.VisualizationSettings.YaxisType.values().length))
                                                .setTitle(UUID.randomUUID().toString())
                                                .setMin(UUID.randomUUID().toString())
                                                .setMax(UUID.randomUUID().toString())
                                                .setPrecision(Int64Value.newBuilder().setValue(111).build())
                                                .setUnitFormatValue(ThreadLocalRandom.current().nextInt(UnitFormat.values().length))
                                                .build())
                                        .setRight(ChartWidget.VisualizationSettings.Yaxis.newBuilder()
                                                .setTypeValue(ThreadLocalRandom.current().nextInt(ChartWidget.VisualizationSettings.YaxisType.values().length))
                                                .setTitle(UUID.randomUUID().toString())
                                                .setMin(UUID.randomUUID().toString())
                                                .setMax(UUID.randomUUID().toString())
                                                .setUnitFormatValue(ThreadLocalRandom.current().nextInt(UnitFormat.values().length))
                                                .build())
                                        .build())
                                .build())
                        .build())
                .build();
    }

    private static Widget chartInterval() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setChart(ChartWidget.newBuilder()
                        .setId(UUID.randomUUID().toString())
                        .setQueries(ChartWidget.Queries.newBuilder()
                                .setDownsampling(Downsampling.newBuilder()
                                        .setGridInterval(ThreadLocalRandom.current().nextInt())
                                        .build())
                                .build())
                        .setVisualizationSettings(ChartWidget.VisualizationSettings.newBuilder()
                                .setColorSchemeSettings(ChartWidget.VisualizationSettings.ColorSchemeSettings.newBuilder()
                                        .setAutomatic(ChartWidget.VisualizationSettings.ColorSchemeSettings.AutomaticColorScheme.newBuilder().build())
                                        .build())
                                .build())
                        .build())
                .build();
    }

    private static Widget chart2() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setChart(ChartWidget.newBuilder()
                        .setId(UUID.randomUUID().toString())
                        .setVisualizationSettings(ChartWidget.VisualizationSettings.newBuilder()
                                .setColorSchemeSettings(ChartWidget.VisualizationSettings.ColorSchemeSettings.newBuilder()
                                        .setStandard(ChartWidget.VisualizationSettings.ColorSchemeSettings.StandardColorScheme.newBuilder().build())
                                        .build())
                                .build())
                        .build())
                .build();
    }

    private static Widget chartPoints() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setChart(ChartWidget.newBuilder()
                        .setId(UUID.randomUUID().toString())
                        .setQueries(ChartWidget.Queries.newBuilder()
                                .setDownsampling(Downsampling.newBuilder()
                                        .setMaxPoints(ThreadLocalRandom.current().nextInt())
                                        .build())
                                .build())
                        .build())
                .build();
    }

    private static Widget text() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setText(TextWidget.newBuilder()
                        .setText("widgetText")
                        .build())
                .build();
    }

    private static Widget.LayoutPosition getPosition() {
        return Widget.LayoutPosition.newBuilder()
                .setX(ThreadLocalRandom.current().nextInt(1, 100))
                .setY(ThreadLocalRandom.current().nextInt(1, 100))
                .setH(ThreadLocalRandom.current().nextInt(1, 100))
                .setW(ThreadLocalRandom.current().nextInt(1, 100))
                .build();
    }

    private static Widget iframe() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setIframe(IframeWidget.newBuilder()
                        .setUrl("url")
                        .setDescription("iframe")
                        .setTitle("iframeTitle")
                        .build())
                .build();
    }

    private static Widget alert() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setAlert(AlertWidget.newBuilder()
                        .setFolderId("1234folder")
                        .setAlertId(UUID.randomUUID().toString())
                        .setLabelsFilter("setLabelsFilter")
                        .addAllEvalStatusFilters(List.of(
                                EvaluationStatus.EVALUATION_STATUS_ALARM,
                                EvaluationStatus.EVALUATION_STATUS_NO_DATA
                        ))
                        .addAllAnnotationKeys(List.of("key1", "key2"))
                        .setDescription("setDescription")
                        .setTitle("setTitle")
                        .build())
                .build();
    }

    private static Widget title() {
        return Widget.newBuilder()
                .setPosition(getPosition())
                .setTitle(TitleWidget.newBuilder()
                        .setText("widgetTitle")
                        .setSizeValue(ThreadLocalRandom.current().nextInt(4))
                        .build())
                .build();
    }

    public static Entity entity(Dashboard dashboard) {
        return Entity.newBuilder()
                .setParentId(UUID.randomUUID().toString())
                .setId(UUID.randomUUID().toString())
                .setContainerType(ContainerType.FOLDER)
                .setName(UUID.randomUUID().toString())
                .setDescription(UUID.randomUUID().toString())
                .setProto(Proto.pack(dashboard))
                .setCreatedAt(1000)
                .setUpdatedAt(10000)
                .setCreatedBy(UUID.randomUUID().toString())
                .setUpdatedBy(UUID.randomUUID().toString())
                .setVersion(Integer.parseInt(dashboard.getEtag()))
                .build();
    }
}
