package ru.yandex.solomon.gateway.api.v3.cloud.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.gateway.api.v3.DashboardModelFactory;

import static org.junit.Assert.assertEquals;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class CloudDashboardDtoConverterTest {

    @Test
    public void convertToAlphaAndBack() {
        var base = DashboardModelFactory.dashboardPublic();
        var dashboard = base.toBuilder()
                .setParametrization(base.getParametrization().toBuilder()
                        .clearParameters()
                        .addParameters(base.getParametrization().getParameters(0).toBuilder()
                                .clearDescription()
                                .build())
                        .addParameters(base.getParametrization().getParameters(1))
                        .addParameters(base.getParametrization().getParameters(2))
                        .build())
                .build();
        var alphaDashboard = CloudDashboardDtoConverter.toAlphaDashboardModel(dashboard);
        var dashboardConverted = CloudDashboardDtoConverter.fromAlphaDashboardModel(alphaDashboard, dashboard.getName());
        assertEquals(dashboard, dashboardConverted);
    }
}
