package ru.yandex.solomon.gateway.api.v3.intranet.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.alert.protobuf.AlertTemplate;

import static org.junit.Assert.assertEquals;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class AlertTemplateDtoConverterTest {

    private final AlertTemplateDtoConverter converter = new AlertTemplateDtoConverter();

    @Test
    public void conversionTest_expression() {
        var expression = AlertTemplateFactory.randomAlertTemplate(AlertTemplate.TypeCase.EXPRESSION);
        var proto = converter.fromInternalProto(expression);
        var actual = converter.toInternalProto(proto, proto.getServiceProviderId());

        assertEquals(expression, actual);
    }

    @Test
    public void conversionTest_threshold() {
        var expression = AlertTemplateFactory.randomAlertTemplate(AlertTemplate.TypeCase.THRESHOLD);
        var proto = converter.fromInternalProto(expression);
        var actual = converter.toInternalProto(proto, proto.getServiceProviderId());

        assertEquals(expression, actual);
    }
}
