package ru.yandex.solomon.gateway.api.v3.intranet.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Any;
import com.google.rpc.Status;
import org.junit.Test;

import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.solomon.alert.protobuf.AlertTemplate;
import ru.yandex.solomon.operation.OperationDtoConverter;
import ru.yandex.solomon.util.Proto;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class OperationDtoConverterTest {

    private final OperationDtoConverter converter = new OperationDtoConverter();

    @Test
    public void conversionTest_result() {
        var expression = AlertTemplateFactory.randomAlertTemplate(AlertTemplate.TypeCase.EXPRESSION);
        final Operation wrap = converter.wrap(expression);
        assertNotNull(wrap.getCreatedAt());
        assertNotNull(wrap.getModifiedAt());
        assertNotNull(wrap.getId());
        assertNotNull(wrap.getDescription());
        assertTrue(wrap.getDone());
        assertEquals(Any.getDefaultInstance(), wrap.getMetadata());
        assertEquals(expression, Proto.unpack(wrap.getResponse(), AlertTemplate.class));
    }

    @Test
    public void conversionTest_error() {
        var exception = new IllegalArgumentException("abc");
        final Operation wrap = converter.wrap(Any.getDefaultInstance(), exception);
        assertNotNull(wrap.getCreatedAt());
        assertNotNull(wrap.getModifiedAt());
        assertNotNull(wrap.getId());
        assertNotNull(wrap.getDescription());
        assertTrue(wrap.getDone());
        assertEquals(Any.getDefaultInstance(), wrap.getMetadata());
        assertNotEquals(Status.getDefaultInstance(), wrap.getError());
    }
}
