package ru.yandex.solomon.gateway.api.v3.intranet.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Empty;

import ru.yandex.monitoring.api.v3.CreateResourceRequest;
import ru.yandex.monitoring.api.v3.DeleteResourceRequest;
import ru.yandex.monitoring.api.v3.GetResourceRequest;
import ru.yandex.monitoring.api.v3.ListResourcesRequest;
import ru.yandex.monitoring.api.v3.ListResourcesResponse;
import ru.yandex.monitoring.api.v3.ServiceProviderResource;
import ru.yandex.monitoring.api.v3.UpdateResourceRequest;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.gateway.api.v3.intranet.ResourceService;

/**
 * @author Alexey Trushkin
 */
public class ResourceServiceStub implements ResourceService {
    @Override
    public CompletableFuture<ServiceProviderResource> get(GetResourceRequest request, AuthSubject subject) {
        return CompletableFuture.completedFuture(ServiceProviderResource.getDefaultInstance());
    }

    @Override
    public CompletableFuture<ListResourcesResponse> list(ListResourcesRequest request, AuthSubject subject) {
        return CompletableFuture.completedFuture(ListResourcesResponse.getDefaultInstance());
    }

    @Override
    public CompletableFuture<ServiceProviderResource> create(CreateResourceRequest request, AuthSubject subject) {
        return CompletableFuture.completedFuture(ServiceProviderResource.getDefaultInstance());
    }

    @Override
    public CompletableFuture<ServiceProviderResource> update(UpdateResourceRequest request, AuthSubject subject) {
        return CompletableFuture.completedFuture(ServiceProviderResource.getDefaultInstance());
    }

    @Override
    public CompletableFuture<Empty> delete(DeleteResourceRequest request, AuthSubject subject) {
        return CompletableFuture.completedFuture(Empty.getDefaultInstance());
    }

    @Override
    public CompletableFuture<Void> upsert(List<CreateResourceRequest> requests, boolean b, String serviceProviderId) {
        return CompletableFuture.completedFuture(null);
    }
}
