package ru.yandex.solomon.gateway.api.v3.intranet.validators;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.monitoring.api.v3.Widget;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DashboardValidatorTest {

    @Test
    public void checkIntersection() {
        assertIntersects(position(0, 0, 1, 1), position(0, 0, 2, 2));
        assertIntersects(position(0, 0, 3, 3), position(1, 1, 1, 1));
        assertIntersects(position(0, 0, 3, 3), position(0, 0, 4, 1));
        assertIntersects(position(0, 0, 3, 3), position(0, 0, 1, 4));
        assertIntersects(position(5, 5, 5, 5), position(6, 0, 2, 15));
        assertIntersects(position(5, 5, 5, 5), position(0, 6, 15, 2));
        assertIntersects(position(0, 0, 3, 3), position(0, 0, 3, 3));

        assertNotIntersects(position(0, 0, 1, 1), position(1, 0, 1, 1));
        assertNotIntersects(position(0, 0, 1, 1), position(0, 1, 1, 1));
        assertNotIntersects(position(0, 0, 1, 1), position(1, 1, 1, 1));
        assertNotIntersects(position(0, 0, 1, 1), position(2, 2, 1, 1));
    }

    private void assertIntersects(Widget.LayoutPosition position1, Widget.LayoutPosition position2) {
        assertTrue(position1 + " vs " + position2, DashboardValidator.checkIntersection(position1, position2));
        assertTrue(position2 + " vs " + position1, DashboardValidator.checkIntersection(position2, position1));
    }

    private void assertNotIntersects(Widget.LayoutPosition position1, Widget.LayoutPosition position2) {
        assertFalse(position1 + " vs " + position2, DashboardValidator.checkIntersection(position1, position2));
        assertFalse(position2 + " vs " + position1, DashboardValidator.checkIntersection(position2, position1));
    }

    private static Widget.LayoutPosition position(int x, int y, int w, int h) {
        return Widget.LayoutPosition.newBuilder()
                .setX(x)
                .setY(y)
                .setW(w)
                .setH(h)
                .build();
    }
}
