package ru.yandex.solomon.gateway.api.v3alpha;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.idm.dto.RoleRequestDto;
import ru.yandex.monitoring.api.v3.ProjectRoleOperation;
import ru.yandex.monitoring.api.v3.ProjectRoleOperationStatus;
import ru.yandex.monitoring.api.v3.ProjectRoleOperationStatus.OperationStatus;
import ru.yandex.monitoring.api.v3.ProjectRoles;
import ru.yandex.monitoring.api.v3.Role;
import ru.yandex.monitoring.api.v3.RoleListRequest;
import ru.yandex.monitoring.api.v3.RoleListResponse;
import ru.yandex.monitoring.api.v3.UidType;
import ru.yandex.monitoring.api.v3.UpdateRoleListRequest;
import ru.yandex.monitoring.api.v3.UpdateRoleListStatusResponse;
import ru.yandex.solomon.acl.db.memory.InMemoryProjectAclEntryDao;
import ru.yandex.solomon.acl.db.model.AclUidType;
import ru.yandex.solomon.acl.db.model.ProjectAclEntry;
import ru.yandex.solomon.auth.fake.AnonymousAuthorizer;
import ru.yandex.solomon.config.protobuf.TIdmConfig;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.core.db.dao.memory.InMemoryProjectsDao;
import ru.yandex.solomon.gateway.api.v3.intranet.ProjectRoleService;
import ru.yandex.solomon.gateway.api.v3.intranet.impl.ProjectRoleServiceImpl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ProjectRoleServiceImplTest {
    private static final String SYSTEM = "system";
    private static final String PROJECT = "solomon";
    private static final String UID1 = "1";
    private static final String UID2 = "2";

    private ProjectRoleService projectRoleService;
    private StubIdmClient client;
    private InMemoryProjectAclEntryDao dao;

    @Before
    public void before() {
        projectRoleService = new ProjectRoleServiceImpl(
                dao = new InMemoryProjectAclEntryDao(),
                client = new StubIdmClient(),
                TIdmConfig.newBuilder()
                        .setSystemName(SYSTEM)
                        .build(),
                new StaffClientStub(),
                new AnonymousAuthorizer(),
                new SolomonConfHolder(),
                new InMemoryProjectsDao()
        );
    }

    @Test
    public void update() {
        projectRoleService.update(request(), null).join();

        List<RoleRequestDto> state = client.getState();
        assertEquals(3, state.size());
        assertTrue(state.contains(RoleRequestDto.newProjectRoleRequest(1, PROJECT, ru.yandex.solomon.auth.roles.Role.PROJECT_ADMIN.name(), SYSTEM)));
        assertTrue(state.contains(RoleRequestDto.newProjectRoleRequest(UID2, PROJECT, ru.yandex.solomon.auth.roles.Role.EDITOR.name(), SYSTEM, false)));
        assertTrue(state.contains(RoleRequestDto.newProjectRoleRequest(UID2, PROJECT, ru.yandex.solomon.auth.roles.Role.JNS_SENDER.name(), SYSTEM, false)));

        List<RoleRequestDto> deleteState = client.getDeleteState();
        assertEquals(1, deleteState.size());
        assertTrue(deleteState.contains(RoleRequestDto.newProjectRoleRequest(UID2, PROJECT, ru.yandex.solomon.auth.roles.Role.PROJECT_ADMIN.name(), SYSTEM, false)));
    }

    @Test
    public void list() {
        dao.create(projectAclEntry(UID1)).join();
        dao.create(projectAclEntry(UID2)).join();

        RoleListResponse response = projectRoleService.list(RoleListRequest.newBuilder().build(), null).join();
        assertTrue(response.getProjectRolesList().isEmpty());

        response = projectRoleService.list(RoleListRequest.newBuilder().setProjectId(PROJECT).build(), null).join();
        assertEquals(2, response.getProjectRolesList().size());
        assertTrue(response.getProjectRolesList().contains(ProjectRoles.newBuilder()
                .setUid(UID1)
                .setUidType(UidType.UID_TYPE_USER)
                .setName(UID1)
                .addAllRole(List.of(Role.ROLE_ADMIN))
                .build()));
        assertTrue(response.getProjectRolesList().contains(ProjectRoles.newBuilder()
                .setUid(UID2)
                .setName(UID2)
                .setUidType(UidType.UID_TYPE_USER)
                .addAllRole(List.of(Role.ROLE_ADMIN))
                .build()));
    }

    @Test
    public void status() {
        dao.create(projectAclEntry(UID1)).join();
        dao.create(projectAclEntry(UID2)).join();

        var request = request2();
        UpdateRoleListStatusResponse response = projectRoleService.status(request, null).join();

        assertEquals(4, response.getProjectRoleOperationStatusesList().size());
        assertTrue(response.getProjectRoleOperationStatusesList().contains(ProjectRoleOperationStatus.newBuilder()
                .setOperationStatus(OperationStatus.COMPLETED)
                .setProjectRoleOperation(request.getProjectRoleOperationsList().get(0))
                .build()));
        assertTrue(response.getProjectRoleOperationStatusesList().contains(ProjectRoleOperationStatus.newBuilder()
                .setOperationStatus(OperationStatus.NOT_COMPLETED)
                .setProjectRoleOperation(request.getProjectRoleOperationsList().get(1))
                .build()));
        assertTrue(response.getProjectRoleOperationStatusesList().contains(ProjectRoleOperationStatus.newBuilder()
                .setOperationStatus(OperationStatus.NOT_COMPLETED)
                .setProjectRoleOperation(request.getProjectRoleOperationsList().get(2))
                .build()));
        assertTrue(response.getProjectRoleOperationStatusesList().contains(ProjectRoleOperationStatus.newBuilder()
                .setOperationStatus(OperationStatus.NOT_COMPLETED)
                .setProjectRoleOperation(request.getProjectRoleOperationsList().get(3))
                .build()));
    }

    private UpdateRoleListRequest request() {
        return UpdateRoleListRequest.newBuilder()
                .setProjectId(PROJECT)
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID1)
                        .setUidType(UidType.UID_TYPE_GROUP)
                        .setRole(Role.ROLE_ADMIN)
                        .setOperationType(ProjectRoleOperation.OperationType.ADD)
                        .build())
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID2)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_EDITOR)
                        .setOperationType(ProjectRoleOperation.OperationType.ADD)
                        .build())
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID2)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_JNS_SENDER)
                        .setOperationType(ProjectRoleOperation.OperationType.ADD)
                        .build())
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID2)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_ADMIN)
                        .setOperationType(ProjectRoleOperation.OperationType.DELETE)
                        .build())
                .build();
    }

    private UpdateRoleListRequest request2() {
        return UpdateRoleListRequest.newBuilder()
                .setProjectId(PROJECT)
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID1)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_ADMIN)
                        .setOperationType(ProjectRoleOperation.OperationType.ADD)
                        .build())
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID1)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_EDITOR)
                        .setOperationType(ProjectRoleOperation.OperationType.ADD)
                        .build())
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID2)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_VIEWER)
                        .setOperationType(ProjectRoleOperation.OperationType.ADD)
                        .build())
                .addProjectRoleOperations(ProjectRoleOperation.newBuilder()
                        .setUid(UID2)
                        .setUidType(UidType.UID_TYPE_USER)
                        .setRole(Role.ROLE_ADMIN)
                        .setOperationType(ProjectRoleOperation.OperationType.DELETE)
                        .build())
                .build();
    }

    private ProjectAclEntry projectAclEntry(String uid) {
        return new ProjectAclEntry(PROJECT, uid, AclUidType.USER, Set.of(
                ru.yandex.solomon.auth.roles.Role.PROJECT_ADMIN.name()
        ), 0);
    }
}
