package ru.yandex.solomon.gateway.api.v3alpha;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import ru.yandex.staff.StaffClient;
import ru.yandex.staff.StaffGroup;
import ru.yandex.staff.StaffGroupMember;
import ru.yandex.staff.UserInfo;

/**
 * @author Alexey Trushkin
 */
public class StaffClientStub implements StaffClient {

    static final String USER_ID1 = "user 1";
    static final String USER_ID2 = "user 2";
    static final String USER_ID3 = "user 3";
    static final String GROUP_ID1 = "123";
    static final String GROUP_ID2 = "group 2";

    private Map<String, List<StaffGroupMember>> responsesMap = new HashMap<>();

    public StaffClientStub() {
        responsesMap.put(GROUP_ID1, List.of(member(USER_ID1), member(USER_ID2)));
        responsesMap.put(GROUP_ID2, List.of(member(USER_ID1), member(USER_ID2), member(USER_ID3)));
    }

    @Override
    public CompletableFuture<UserInfo> getUserInfo(String login) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<List<UserInfo>> getUserInfo(List<String> login) {
        return CompletableFuture.completedFuture(List.of());
    }

    @Override
    public CompletableFuture<UserInfo> getUserInfoByTelegramLogin(String telegramLogin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<List<StaffGroupMember>> getStaffGroupMembers(String groupId) {
        return CompletableFuture.completedFuture(responsesMap.get(groupId));
    }

    @Override
    public CompletableFuture<List<StaffGroup>> getStaffGroup(List<String> groupIds) {
        return CompletableFuture.completedFuture(groupIds.stream()
                .map(s -> {
                    StaffGroup g = new StaffGroup();
                    g.id = Integer.valueOf(s);
                    g.type = "type";
                    return g;
                })
                .collect(Collectors.toList()));
    }

    @Override
    public void close() {
    }

    private StaffGroupMember member(String s) {
        StaffGroupMember m = new StaffGroupMember();
        m.login = s;
        return m;
    }
}
