package ru.yandex.solomon.gateway.api.v3alpha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.idm.IdmClient;
import ru.yandex.idm.dto.RoleRequestDto;

/**
 * @author Alexey Trushkin
 */
public class StubIdmClient implements IdmClient {

    private List<RoleRequestDto> state = new ArrayList<>();
    private List<RoleRequestDto> deleteState = new ArrayList<>();
    private List<RoleRequestDto> deleteRolesState = new ArrayList<>();

    @Override
    public CompletableFuture<Void> requestRole(RoleRequestDto requestDto) {
        state.add(requestDto);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteRole(RoleRequestDto requestDto) {
        deleteState.add(requestDto);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteRoles(RoleRequestDto projectRequest) {
        deleteRolesState.add(projectRequest);
        return CompletableFuture.completedFuture(null);
    }

    public List<RoleRequestDto> getState() {
        return Collections.unmodifiableList(state);
    }

    public List<RoleRequestDto> getDeleteState() {
        return Collections.unmodifiableList(deleteState);
    }

    public List<RoleRequestDto> getDeleteRolesState() {
        return deleteRolesState;
    }

    @Override
    public void close() {
    }
}
