package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.validators;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.monitoring.v3.cloud.priv.ServiceDashboardValidationIssue;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class NamesValidatorTest {

    private NamesValidator validator;

    @Before
    public void before() {
        validator = new NamesValidator();
    }

    @Test
    public void validate() {
        var result = validator.validate(ServiceDashboardFactory.dashboard()).join();
        assertEquals(List.of(), result);
    }

    @Test
    public void validateWithErrors() {
        var result = validator.validate(ServiceDashboardFactory.dashboardErrors()).join();
        assertEquals(3, result.size());
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                .setDescription("Name '' should be specified and starts with a capital letter")
                .build()));
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                .setDescription("Name 'text 1' should be specified and starts with a capital letter")
                .build()));
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                .setDescription("Name ' ' should be specified and starts with a capital letter")
                .build()));
    }
}
