package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.validators;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.monitoring.v3.cloud.priv.ServiceDashboardValidationIssue;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ParametersValidatorTest {

    private ParametersValidator validator;

    @Before
    public void before() {
        validator = new ParametersValidator();
    }

    @Test
    public void validate() {
        var result = validator.validate(ServiceDashboardFactory.dashboard()).join();
        assertEquals(List.of(), result);
    }

    @Test
    public void validateWithErrors() {
        var result = validator.validate(ServiceDashboardFactory.dashboardErrors()).join();
        assertEquals(4, result.size());
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                .setDescription("Parametrization should contain at least one parameter")
                .build()));
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.ERROR)
                .setDescription("Label 'service' value should be 'Service 1' in parametrization selector")
                .build()));
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                .setDescription("UnitFormat should be specified instead of 'UNIT_FORMAT_NOT_SPECIFIED'")
                .build()));
        assertTrue(result.contains(ServiceDashboardValidationIssue.newBuilder()
                .setSeverity(ServiceDashboardValidationIssue.Severity.WARN)
                .setDescription("UnitFormat should be specified instead of 'UNIT_NONE'")
                .build()));
    }
}
