package ru.yandex.solomon.gateway.api.v3alpha.cloud.priv.validators;

import ru.yandex.monitoring.v3.cloud.ChartWidget;
import ru.yandex.monitoring.v3.cloud.ChartWidget.VisualizationSettings.UnitFormat;
import ru.yandex.monitoring.v3.cloud.Parameter;
import ru.yandex.monitoring.v3.cloud.Parametrization;
import ru.yandex.monitoring.v3.cloud.ServiceDashboard;
import ru.yandex.monitoring.v3.cloud.TextWidget;
import ru.yandex.monitoring.v3.cloud.TitleWidget;
import ru.yandex.monitoring.v3.cloud.Widget;

/**
 * @author Alexey Trushkin
 */
class ServiceDashboardFactory {

    static final String SERVICE = "Service 1";
    static final String NAME = "Name 1";
    static final String DESCRIPTION = "Desc 1";
    static final String TITLE = "Title 1";
    static final String TEXT = "Text 1";
    static final String TEXT_ERROR = "text 1";
    static final String VALID_SELECTOR = "{service='Service 1', resource_type='type'}";
    static final String ERROR_SELECTOR = "{service='solomon', resource_type='type'}";

    static ServiceDashboard dashboard() {
        return ServiceDashboard.newBuilder()
                .setService(SERVICE)
                .setName(NAME)
                .setDescription(DESCRIPTION)
                .addWidgets(widgetChart(false))
                .addWidgets(widgetText(false))
                .addWidgets(widgetTitle())
                .setParametrization(parametrization(false))
                .build();
    }

    static ServiceDashboard dashboardErrors() {
        return ServiceDashboard.newBuilder()
                .setService(SERVICE)
                .setDescription(DESCRIPTION)
                .addWidgets(widgetChart(true))
                .addWidgets(widgetChartRight())
                .addWidgets(widgetChartWithoutError())
                .addWidgets(widgetText(true))
                .addWidgets(widgetTitle())
                .setParametrization(parametrization(true))
                .build();
    }

    private static Widget widgetChartWithoutError() {
        return Widget.newBuilder()
                .setChart(ChartWidget.newBuilder()
                        .setTitle(TITLE)
                        .setVisualizationSettings(ChartWidget.VisualizationSettings.newBuilder()
                                .setYaxisSettings(ChartWidget.VisualizationSettings.YaxisSettings.newBuilder()
                                        .setRight(ChartWidget.VisualizationSettings.Yaxis.newBuilder()
                                                .setUnitFormat(UnitFormat.UNIT_NONE)
                                                .build())
                                        .setLeft(ChartWidget.VisualizationSettings.Yaxis.newBuilder()
                                                .setUnitFormat(UnitFormat.UNIT_FORMAT_NOT_SPECIFIED)
                                                .build())
                                        .build())
                                .build())
                        .build())
                .build();
    }

    private static Widget widgetChartRight() {
        return Widget.newBuilder()
                .setChart(ChartWidget.newBuilder()
                        .setTitle(TITLE)
                        .addSeriesOverrides(ChartWidget.SeriesOverrides.newBuilder()
                                .setSettings(ChartWidget.SeriesOverrides.SeriesOverrideSettings.newBuilder()
                                        .setYaxisPosition(ChartWidget.SeriesOverrides.YaxisPosition.YAXIS_POSITION_RIGHT)
                                        .build())
                                .build())
                        .setVisualizationSettings(ChartWidget.VisualizationSettings.newBuilder()
                                .setYaxisSettings(ChartWidget.VisualizationSettings.YaxisSettings.newBuilder()
                                        .setRight(ChartWidget.VisualizationSettings.Yaxis.newBuilder()
                                                .setUnitFormat(UnitFormat.UNIT_NONE)
                                                .build())
                                        .build())
                                .build())
                        .build())
                .build();
    }


    private static Parametrization parametrization(boolean error) {
        var builder = Parametrization.newBuilder()
                .setSelectors(error ? ERROR_SELECTOR : VALID_SELECTOR);

        if (!error) {
            builder.addParameters(Parameter.newBuilder()
                    .setTitle(TITLE)
                    .build());
        }

        return builder.build();
    }

    private static Widget widgetChart(boolean error) {
        return Widget.newBuilder()
                .setChart(ChartWidget.newBuilder()
                        .setTitle(error ? " " : TITLE)
                        .addSeriesOverrides(ChartWidget.SeriesOverrides.newBuilder()
                                .setSettings(ChartWidget.SeriesOverrides.SeriesOverrideSettings.newBuilder()
                                        .setYaxisPosition(ChartWidget.SeriesOverrides.YaxisPosition.YAXIS_POSITION_LEFT)
                                        .build())
                                .build())
                        .setVisualizationSettings(ChartWidget.VisualizationSettings.newBuilder()
                                .setYaxisSettings(ChartWidget.VisualizationSettings.YaxisSettings.newBuilder()
                                        .setLeft(ChartWidget.VisualizationSettings.Yaxis.newBuilder()
                                                .setUnitFormat(error ? UnitFormat.UNIT_FORMAT_NOT_SPECIFIED : UnitFormat.UNIT_BITS_IEC)
                                                .build())
                                        .build())
                                .build())
                        .build())
                .build();
    }

    private static Widget widgetText(boolean error) {
        return Widget.newBuilder()
                .setText(TextWidget.newBuilder()
                        .setText(error ? TEXT_ERROR : TEXT)
                        .build())
                .build();
    }

    private static Widget widgetTitle() {
        return Widget.newBuilder()
                .setTitle(TitleWidget.newBuilder()
                        .setText(TITLE)
                        .build())
                .build();
    }
}
