package ru.yandex.solomon.gateway.api.v3alpha.dao.ydb;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.util.Timestamps;
import org.junit.Test;

import ru.yandex.monitoring.v3.cloud.CustomParameter;
import ru.yandex.monitoring.v3.cloud.Dashboard;
import ru.yandex.monitoring.v3.cloud.LabelValuesParameter;
import ru.yandex.monitoring.v3.cloud.Parameter;
import ru.yandex.monitoring.v3.cloud.Parametrization;
import ru.yandex.monitoring.v3.cloud.TextWidget;
import ru.yandex.monitoring.v3.cloud.Widget;
import ru.yandex.solomon.conf.db3.ydb.Entity;
import ru.yandex.solomon.core.container.ContainerType;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class CloudDashboardConverterTest {

    @Test
    public void encode() {
        Dashboard dashboard = getDashboard();
        Entity entity = CloudDashboardConverter.encode(dashboard, "localId");

        assertEquals(entity.getId(), dashboard.getId());
        assertEquals(entity.getParentId(), dashboard.getFolderId());
        assertEquals(entity.getName(), dashboard.getName());
        assertEquals(entity.getLocalId(), "localId");
        assertEquals(entity.getDescription(), dashboard.getDescription());
        assertEquals(entity.getCreatedBy(), dashboard.getCreatedBy());
        assertEquals(entity.getUpdatedBy(), dashboard.getUpdatedBy());
        assertEquals(entity.getVersion(), dashboard.getVersion());
        assertEquals(entity.getContainerType(), ContainerType.FOLDER);
        assertEquals(entity.getCreatedAt(), Timestamps.toMillis(dashboard.getCreatedAt()));
        assertEquals(entity.getUpdatedAt(), Timestamps.toMillis(dashboard.getUpdatedAt()));
        assertNotNull(entity.getData());
        assertNotNull(entity.getProto());
    }

    @Test
    public void conversion_old() {
        Dashboard dashboard = getDashboard();
        Entity entity = CloudDashboardConverter.encode(dashboard, "localId");
        var converted = CloudDashboardConverter.decode(entity);
        assertEquals(dashboard, converted);
    }

    @Test
    public void conversion_new() {
        Dashboard dashboard = getDashboard();
        Entity entity = CloudDashboardConverter.encode(dashboard, "localId");
        var converted = CloudDashboardConverter.decode(entity);
        assertEquals(dashboard, converted);
    }

    private Dashboard getDashboard() {
        return Dashboard.newBuilder()
                .setFolderId(UUID.randomUUID().toString())
                .setId(UUID.randomUUID().toString())
                .setName(UUID.randomUUID().toString())
                .setDescription(UUID.randomUUID().toString())
                .setCreatedBy(UUID.randomUUID().toString())
                .setUpdatedBy(UUID.randomUUID().toString())
                .setUpdatedAt(Timestamps.fromMillis(1000))
                .setCreatedAt(Timestamps.fromMillis(100))
                .setParametrization(Parametrization.newBuilder()
                        .setSelectors("someSelector")
                        .addAllParameters(List.of(
                                Parameter.newBuilder()
                                        .setName("1")
                                        .setTitle("2")
                                        .setHidden(true)
                                        .setLabelValues(LabelValuesParameter.newBuilder()
                                                .setFolderId("folderId")
                                                .setSelectors("another")
                                                .setLabelKey("key")
                                                .setMultiselectable(true)
                                                .addAllDefaultValues(List.of("1", "2", "3"))
                                                .buildPartial())
                                        .build(),
                                Parameter.newBuilder()
                                        .setCustom(CustomParameter.newBuilder()
                                                .addAllValues(List.of("1", "2", "3"))
                                                .setMultiselectable(true)
                                                .addAllDefaultValues(List.of("1", "2", "3", "4"))
                                                .build())
                                        .build()))
                        .build())
                .addAllWidgets(List.of(
                        Widget.newBuilder()
                                .setPosition(Widget.LayoutPosition.newBuilder()
                                        .setH(1)
                                        .setW(1)
                                        .setX(1)
                                        .setY(1)
                                        .build())
                                .setText(TextWidget.newBuilder()
                                        .setText(UUID.randomUUID().toString())
                                        .build())
                                .build()
                ))
                .setVersion(11)
                .putAllLabels(Map.of(UUID.randomUUID().toString(), UUID.randomUUID().toString()))
                .build();
    }
}
