package ru.yandex.solomon.gateway.backend.www;

import org.junit.Assert;
import org.junit.Test;


/**
 * @author rorewillo
 */
public class MetricsChecksSetTest {

    @Test
    public void parse() {
        testParsing("", false);

        testParsing("+", true);
        testParsing("-", false);

        testParsing("+aaa", true, "aaa");
        testParsing("-aaa", false, "aaa");

        testParsing("+aaa;bbb", true, "aaa", "bbb");
        testParsing("-aaa;bbb", false, "aaa", "bbb");

        testParsing("+;\\;;\\;\\;;aa;bb\\;bb;\\;cc;dd\\;", true, "", ";", ";;", "aa", "bb;bb", ";cc", "dd;");
    }

    private static void testParsing(String value, boolean positive, String... metricIds) {
        MetricsChecksSet expected = new MetricsChecksSet(positive, metricIds);
        MetricsChecksSet actual = MetricsChecksSet.parse(value);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void include() {
        {
            MetricsChecksSet checks = new MetricsChecksSet(false);
            Assert.assertTrue("empty (include all)", checks.include("id"));
        }

        {
            MetricsChecksSet checks = new MetricsChecksSet(true);
            Assert.assertFalse("empty (exclude all)", checks.include("id"));
        }

        {
            MetricsChecksSet checks = new MetricsChecksSet(false);
            Assert.assertTrue(checks.include(""));
            Assert.assertTrue(checks.include("id"));
        }

        {
            MetricsChecksSet checks = new MetricsChecksSet(true);
            Assert.assertFalse(checks.include(""));
            Assert.assertFalse(checks.include("id"));
        }

        {
            MetricsChecksSet checks = new MetricsChecksSet(true, "xxx=yyy");
            Assert.assertFalse(checks.include(""));
            Assert.assertTrue("included xxx=yyy", checks.include("xxx=yyy"));
            Assert.assertFalse("excluded xxx", checks.include("xxx"));
        }

        {
            MetricsChecksSet checks = new MetricsChecksSet(false, "xxx=yyy");
            Assert.assertTrue(checks.include(""));
            Assert.assertTrue("included xxx", checks.include("xxx"));
            Assert.assertFalse("excluded xxx=yyy", checks.include("xxx=yyy"));
        }

        {
            MetricsChecksSet checks = new MetricsChecksSet(true, "aaa=bbb", "ccc=ddd");
            Assert.assertTrue("included aaa=bbb", checks.include("aaa=bbb"));
            Assert.assertTrue("inluded ccc=ddd", checks.include("ccc=ddd"));
            Assert.assertFalse("excluded aaa=ddd", checks.include("aaa=ddd"));
        }
    }
}
