package ru.yandex.solomon.gateway.dao.ydb;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.gateway.dao.StubRequestDaoTest;
import ru.yandex.solomon.gateway.inject.spring.GatewayIdempotentOperationContext;
import ru.yandex.solomon.gateway.stub.dao.ydb.YdbStubRequestDao;
import ru.yandex.solomon.idempotency.dao.IdempotentOperationDao;
import ru.yandex.solomon.idempotency.dao.ydb.YdbIdempotentOperationDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

/**
 * @author Nuradil Zhambyl
 */
public class YdbStubRequestDaoTest extends StubRequestDaoTest {

    @ClassRule
    public static LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();
    private YdbStubRequestDao ydbDao;
    private YdbIdempotentOperationDao operationsDao;

    @Before
    public void setUp() throws Exception {
        var mapper = new ObjectMapper();
        var ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        var root = ydb.getRootPath();

        ydbDao = new YdbStubRequestDao(root, root + GatewayIdempotentOperationContext.PATH, ydb.getTableClient(), ydb.getSchemeClient());
        operationsDao = new YdbIdempotentOperationDao(root + GatewayIdempotentOperationContext.PATH, ydb.getTableClient(), ydb.getSchemeClient());
        operationsDao.createSchemaForTests().join();
        ydbDao.createSchemaForTests().join();
    }

    @Override
    public YdbStubRequestDao getDao() {
        return ydbDao;
    }

    @Override
    protected IdempotentOperationDao getOperationsDao() {
        return operationsDao;
    }
}
