package ru.yandex.solomon.gateway.data;

import java.util.concurrent.TimeUnit;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class DownsamplingOptionsTest {

    @Test
    public void byInterval() {
        var opts = DownsamplingOptions.newBuilder()
                .setGridMillis(60_000)
                .setPoints(100)
                .setDownsamplingType(DownsamplingType.BY_INTERVAL)
                .build();

        long result = opts.computeGridMillis(TimeUnit.DAYS.toMillis(1));
        assertEquals(result, 60_000);
    }

    @Test
    public void byPoints() {
        var opts = DownsamplingOptions.newBuilder()
                .setPoints(100)
                .setGridMillis(60_000)
                .setDownsamplingType(DownsamplingType.BY_POINTS)
                .build();

        var result = opts.computeGridMillis(TimeUnit.HOURS.toMillis(1));
        assertEquals(TimeUnit.SECONDS.toMillis(36), result);
    }

    @Test
    public void downsamplingByDefault() {
        var opts = DownsamplingOptions.newBuilder().build();
        assertEquals(DownsamplingType.BY_POINTS, opts.getDownsamplingType());
        assertEquals(500, opts.getPoints());
    }
}
