package ru.yandex.solomon.gateway.entityConverter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ConvertFilterParserTest {

    @Test
    public void blank() {
        var actual = ConvertFilterParser.parse("");
        var expected = List.of();
        assertEquals(expected, actual);
    }

    @Test
    public void singleProject() {
        var actual = ConvertFilterParser.parse("solomon");
        var expected = List.of(ProjectEntityFilter.all("solomon"));
        assertEquals(expected, actual);
    }

    @Test
    public void severalProjects() {
        var actual = ConvertFilterParser.parse("solomon,kikimr,logbroker");
        var expected = List.of(
            ProjectEntityFilter.all("solomon"),
            ProjectEntityFilter.all("kikimr"),
            ProjectEntityFilter.all("logbroker")
        );
        assertEquals(expected, actual);
    }

    @Test(expected = IllegalArgumentException.class)
    public void unknownType() {
        ConvertFilterParser.parse("solomon/graphs");
    }

    @Test(expected = IllegalArgumentException.class)
    public void unknownConcreteType() {
        ConvertFilterParser.parse("solomon/alerts/alert1");
    }

    @Test
    public void projectMenu() {
        var actual = ConvertFilterParser.parse("solomon/menu");
        var expected = List.of(
            new ProjectEntityFilter("solomon", ProjectEntityFilter.Mode.MENU, "", "")
        );
        assertEquals(expected, actual);
    }

    @Test
    public void projectGraphsAndDashboards() {
        var actual = ConvertFilterParser.parse("solomon/graphs_dashboards");
        var expected = List.of(
            new ProjectEntityFilter("solomon", ProjectEntityFilter.Mode.GRAPHS_DASHBOARDS, "", "")
        );
        assertEquals(expected, actual);
    }

    @Test
    public void concreteDashboard() {
        var actual = ConvertFilterParser.parse("solomon/dashboards/dash1");
        var expected = List.of(
            new ProjectEntityFilter("solomon", ProjectEntityFilter.Mode.CONCRETE_DASHBOARD, "dash1", "")
        );
        assertEquals(expected, actual);
    }

    @Test
    public void concreteDashboardWithWidget() {
        var actual = ConvertFilterParser.parse("solomon/dashboards/dash1/widget1_1");
        var expected = List.of(
            new ProjectEntityFilter("solomon", ProjectEntityFilter.Mode.CONCRETE_DASHBOARD, "dash1", "widget1_1")
        );
        assertEquals(expected, actual);
    }

    @Test
    public void concreteGraph() {
        var actual = ConvertFilterParser.parse("solomon/graphs/graph1");
        var expected = List.of(
            new ProjectEntityFilter("solomon", ProjectEntityFilter.Mode.CONCRETE_GRAPH, "graph1", "")
        );
        assertEquals(expected, actual);
    }

    @Test
    public void severalFilters() {
        var actual = ConvertFilterParser.parse(" solomon, kikimr/graphs_dashboards, logbroker, yt/graphs/graph1 ");
        var expected = List.of(
            ProjectEntityFilter.all("solomon"),
            new ProjectEntityFilter("kikimr", ProjectEntityFilter.Mode.GRAPHS_DASHBOARDS, "", ""),
            ProjectEntityFilter.all("logbroker"),
            new ProjectEntityFilter("yt", ProjectEntityFilter.Mode.CONCRETE_GRAPH, "graph1", "")
        );
        assertEquals(expected, actual);
    }
}
