package ru.yandex.solomon.gateway.entityConverter;

import java.time.Instant;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.core.db.model.Selector;
import ru.yandex.solomon.core.db.model.graph.AggregationType;
import ru.yandex.solomon.core.db.model.graph.ColorSchemeType;
import ru.yandex.solomon.core.db.model.graph.DownsamplingAggregationType;
import ru.yandex.solomon.core.db.model.graph.DownsamplingFillType;
import ru.yandex.solomon.core.db.model.graph.DownsamplingMode;
import ru.yandex.solomon.core.db.model.graph.ElementTransform;
import ru.yandex.solomon.core.db.model.graph.FilterFunction;
import ru.yandex.solomon.core.db.model.graph.FilterOrder;
import ru.yandex.solomon.core.db.model.graph.Graph;
import ru.yandex.solomon.core.db.model.graph.GraphElement;
import ru.yandex.solomon.core.db.model.graph.GraphElementType;
import ru.yandex.solomon.core.db.model.graph.GraphMode;
import ru.yandex.solomon.core.db.model.graph.GraphTransform;
import ru.yandex.solomon.core.db.model.graph.InterpolationType;
import ru.yandex.solomon.core.db.model.graph.OverLinesTransform;
import ru.yandex.solomon.core.db.model.graph.ScaleType;
import ru.yandex.solomon.core.db.model.graph.SecondaryGraphMode;
import ru.yandex.solomon.core.db.model.graph.YaxisPosition;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class GraphToSettingsConverterTest {

    private static final Graph EMPTY_MODEL_GRAPH = Graph.newBuilder()
            .setId("")
            .setProjectId("")
            .setName("Graph name")
            .build();

    private static final Graph FULL_MODEL_GRAPH = new Graph(
            "",
            "",
            "",
            "Graph name",
            "description",
            new Selector[]{
                    new Selector("label1", "value1"),
                    new Selector("label2", "value2")
            },
            new GraphElement[] {
                    new GraphElement(
                            "title 1",
                            GraphElementType.EXPRESSION,
                            new Selector[] { new Selector("label3", "value3")},
                            "x",
                            null,
                            false,
                            "stack",
                            true,
                            "red",
                            YaxisPosition.RIGHT,
                            ElementTransform.INTEGRATE
                    ),
                    new GraphElement(
                            "title 2",
                            GraphElementType.SELECTORS,
                            new Selector[] { new Selector("label3", "value3")},
                            "",
                            "https://yandex.ru",
                            true,
                            "stack",
                            true,
                            "red",
                            YaxisPosition.LEFT,
                            ElementTransform.DIFFERENTIATE_WITH_NEGATIVE
                    ),
                    new GraphElement(
                            "title 3",
                            GraphElementType.SELECTORS,
                            new Selector[] { new Selector("label4", "value4")},
                            "",
                            "https://yandex.ru",
                            null,
                            "stack",
                            null,
                            "red",
                            YaxisPosition.LEFT,
                            ElementTransform.DIFFERENTIATE_WITH_NEGATIVE
                    )
            },
            GraphMode.BARS,
            SecondaryGraphMode.BARS,
            "123",
            "456",
            true,
            ColorSchemeType.GRADIENT,
            true,
            true,
            AggregationType.MAX,
            InterpolationType.LEFT,
            ScaleType.LOG,
            "12_auto",
            "100", "200", "300", "400", "100", "200", "300", "400",
            "host",
            true,
            "100",
            OverLinesTransform.PERCENTILE,
            "50,90,99",
            "bucket",
            true,
            FilterOrder.TOP,
            FilterFunction.MAX,
            "10",
            GraphTransform.INTEGRATE,
            "10m",
            "90",
            DownsamplingMode.BY_INTERVAL,
            DownsamplingAggregationType.LAST,
            DownsamplingFillType.NONE,
            true,
            "10m",
            100,
            true,
            15d,
            "",
            Instant.EPOCH,
            Instant.EPOCH,
            "",
            "",
            0
    );

    @Test
    public void empty() {
        Map<String, String> actual = GraphToSettingsConverter.convert(EMPTY_MODEL_GRAPH);
        Map<String, String> expected = Map.of();
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void full() {
        Map<String, String> actual = GraphToSettingsConverter.convert(FULL_MODEL_GRAPH);
        Map<String, String> expected = Map.ofEntries(
                Map.entry("description", "description"),
                Map.entry("graphMode", "bars"),
                Map.entry("secondaryGraphMode", "bars"),
                Map.entry("stack", "true"),
                Map.entry("scale", "log"),
                Map.entry("interpolate", "left"),
                Map.entry("aggr", "max"),
                Map.entry("dropNaN", "true"),
                Map.entry("numberFormat", "12_auto"),
                Map.entry("cs", "gradient"),
                Map.entry("green", "100"),
                Map.entry("yellow", "200"),
                Map.entry("red", "300"),
                Map.entry("violet", "400"),
                Map.entry("greenValue", "100"),
                Map.entry("yellowValue", "200"),
                Map.entry("redValue", "300"),
                Map.entry("violetValue", "400"),
                Map.entry("norm", "true"),
                Map.entry("min", "123"),
                Map.entry("max", "456"),
                Map.entry("limit", "100"),
                Map.entry("transform", "integrate"),
                Map.entry("movingWindow", "10m"),
                Map.entry("movingPercentile", "90"),
                Map.entry("overLinesTransform", "PERCENTILE"),
                Map.entry("percentiles", "50,90,99"),
                Map.entry("bucketLabel", "bucket"),
                Map.entry("filter", "top"),
                Map.entry("filterBy", "max"),
                Map.entry("filterLimit", "10"),
                Map.entry("downsampling", "byInterval"),
                Map.entry("grid", "10m"),
                Map.entry("maxPoints", "100"),
                Map.entry("downsamplingAggr", "last"),
                Map.entry("downsamplingFill", "none"),
                Map.entry("hideNoData", "true"),
                Map.entry("threshold", "15.0")
        );
        Assert.assertEquals(expected, actual);
    }
}
