package ru.yandex.solomon.gateway.entityConverter;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Oleg Baryshnikov
 */
public class TableWithSpansBuilderTest {

    @Test
    public void test1() {
        TableWithSpansBuilder<String> table = new TableWithSpansBuilder<>();
        table.setSpannedCell(0, 0, 1, 1, "1,1");
        table.setSpannedCell(0, 1, 2, 1, "1,2 |");
        table.setSpannedCell(1, 0, 1, 2, "2,1 --");
        table.setSpannedCell(1, 1, 1, 1, "2,2");
        Assert.assertEquals(5, table.columnCount());
        Assert.assertEquals(2, table.rowCount());
        Assert.assertEquals("1,1", table.getCellOrEmpty(0, 0).getContentOrNull());
        Assert.assertEquals("1,2 |", table.getCellOrEmpty(0, 1).getContentOrNull());
        Assert.assertEquals("2,1 --", table.getCellOrEmpty(1, 2).getContentOrNull());
        Assert.assertEquals("2,2", table.getCellOrEmpty(1, 4).getContentOrNull());
    }

    @Test
    public void test2() {
        TableWithSpansBuilder<String> table = new TableWithSpansBuilder<>();
        table.setSpannedCell(0, 0, 1, 1, "1,1");
        table.setSpannedCell(0, 1, 2, 1, "1,2 |");
        Assert.assertEquals(2, table.columnCount());
        Assert.assertEquals(2, table.rowCount());
    }

    @Test
    public void test3() {
        TableWithSpansBuilder<String> table = new TableWithSpansBuilder<>();
        table.setSpannedCell(0, 0, 1, 1, "1,1");
        table.setSpannedCell(1, 0, 1, 2, "2,1 --");
        Assert.assertEquals(2, table.columnCount());
        Assert.assertEquals(2, table.rowCount());
    }

    @Test
    public void test4() {
        TableWithSpansBuilder<String> table = new TableWithSpansBuilder<>();
        table.setSpannedCell(0, 0, 2, 1, "1,1 |");
        table.setSpannedCell(0, 1, 2, 1, "1,2 |");
        table.setSpannedCell(1, 0, 1, 2, "2,1 --");
        Assert.assertEquals("1,1 |", table.getCellOrEmpty(0, 0).getContentOrNull());
        Assert.assertEquals("1,2 |", table.getCellOrEmpty(0, 1).getContentOrNull());
        Assert.assertEquals("2,1 --", table.getCellOrEmpty(1, 2).getContentOrNull());
    }
}
