package ru.yandex.solomon.gateway.operations.db.ydb;


import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.gateway.operations.db.LongRunningOperationDao;
import ru.yandex.solomon.gateway.operations.db.LongRunningOperationDaoTest;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Stanislav Kashirin
 */
public class YdbLongRunningOperationDaoTest extends LongRunningOperationDaoTest {

    @ClassRule
    public static final LocalKikimr kikimr = new LocalKikimr();

    @Rule
    public TestName testName = new TestName();

    private YdbHelper ydb;
    private YdbLongRunningOperationDao dao;

    @Before
    public void setUp() throws Exception {
        ydb = new YdbHelper(kikimr, this.getClass().getSimpleName() + "_" + testName.getMethodName());
        dao = new YdbLongRunningOperationDao(ydb.getRootPath(), ydb.getTableClient());
        join(dao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected LongRunningOperationDao getDao() {
        return dao;
    }
}
