package ru.yandex.solomon.gateway.push;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.discovery.cluster.ClusterMapperStub;


/**
 * @author alexlovkov
 **/
public class PushDisablerTest {

    @Test
    public void test() {
        PushDisabler pushDisabler = new PushDisabler(buildClusterMapper());

        pushDisabler.disableDc("sas");
        List<String> list = new ArrayList<>();
        list.add("solomon-stp-sas-000.search.yandex.net");
        list.add("solomon-stp-myt-00.search.yandex.net");

        List<String> filtered = pushDisabler.filterFqdn(list);
        Assert.assertEquals(1, filtered.size());
        Assert.assertEquals("solomon-stp-myt-00.search.yandex.net", filtered.get(0));

        pushDisabler.clear();
        pushDisabler.disableDc("man");
        pushDisabler.disableDc("sas");
        list.add("solomon-stp-man-00.search.yandex.net");
        filtered = pushDisabler.filterFqdn(list);
        Assert.assertEquals(1, filtered.size());
        Assert.assertEquals("solomon-stp-myt-00.search.yandex.net", filtered.get(0));

        pushDisabler.enableDc("sas");
        filtered = pushDisabler.filterFqdn(list);
        Assert.assertEquals(2, filtered.size());
        Assert.assertEquals("solomon-stp-sas-000.search.yandex.net", filtered.get(0));
        Assert.assertEquals("solomon-stp-myt-00.search.yandex.net", filtered.get(1));
    }

    @Test
    public void testFilterToEmpty() {
        PushDisabler pushDisabler = new PushDisabler(buildClusterMapper());
        pushDisabler.disableDc("sas");
        List<String> list = new ArrayList<>();
        list.add("solomon-stp-sas-000.search.yandex.net");
        list.add("solomon-stp-sas-001.search.yandex.net");
        list.add("solomon-stp-sas-002.search.yandex.net");
        List<String> filtered = pushDisabler.filterFqdn(list);
        Assert.assertTrue(filtered.isEmpty());
    }

    @Test
    public void filterOneCluster() {
        PushDisabler pushDisabler = new PushDisabler(buildClusterMapper());
        pushDisabler.disableDc("sas");
        List<String> list = new ArrayList<>();
        list.add("solomon-stp-sas-000.search.yandex.net");
        list.add("solomon-stp-sas-001.search.yandex.net");
        list.add("solomon-stp-sas-002.search.yandex.net");
        list.add("solomon-stp-man-00.search.yandex.net");
        list.add("solomon-stp-man-01.search.yandex.net");
        list.add("solomon-stp-man-02.search.yandex.net");
        List<String> filtered = pushDisabler.filterFqdn(list);
        Assert.assertEquals(3, filtered.size());
        for (String s : filtered) {
            Assert.assertTrue(s.contains("solomon-stp-man"));
        }
    }

    ClusterMapper buildClusterMapper() {
        ClusterMapperStub mapper = new ClusterMapperStub();
        mapper.clusterByHost.put("solomon-stp-man-00.search.yandex.net", "man");
        mapper.clusterByHost.put("solomon-stp-man-01.search.yandex.net", "man");
        mapper.clusterByHost.put("solomon-stp-man-02.search.yandex.net", "man");

        mapper.clusterByHost.put("solomon-stp-myt-00.search.yandex.net", "myt");
        mapper.clusterByHost.put("solomon-stp-myt-01.search.yandex.net", "myt");
        mapper.clusterByHost.put("solomon-stp-myt-02.search.yandex.net", "myt");

        mapper.clusterByHost.put("solomon-stp-sas-000.search.yandex.net", "sas");
        mapper.clusterByHost.put("solomon-stp-sas-001.search.yandex.net", "sas");
        mapper.clusterByHost.put("solomon-stp-sas-002.search.yandex.net", "sas");
        return mapper;
    }
}
