package ru.yandex.solomon.gateway.push;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.proto.UrlStatusType;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.emptyIterable;
import static org.springframework.http.HttpStatus.INTERNAL_SERVER_ERROR;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class PushStatusToHttpStatusTest {
    @Test
    public void allPushStatusesCovered() {
        final Set<UrlStatusType> ALLOWED_TO_MAP_TO_500 = Set.of(
            UrlStatusType.UNKNOWN_HOST,
            UrlStatusType.CONNECT_FAILURE,
            UrlStatusType.NOT_200,
            UrlStatusType.UNKNOWN_STATUS_TYPE,

            UrlStatusType.UNKNOWN_ERROR,
            UrlStatusType.UNRECOGNIZED
        );
        var notMapped = Arrays.stream(UrlStatusType.values())
            .filter(status -> PushStatusToHttpStatus.convert(status) == INTERNAL_SERVER_ERROR)
            .filter(status -> !ALLOWED_TO_MAP_TO_500.contains(status))
            .collect(Collectors.toSet());

        assertThat(notMapped, emptyIterable());
    }
}
