package ru.yandex.solomon.gateway.tasks.deleteMetrics;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

import ru.yandex.gateway.api.task.DeleteMetricsParams;

import static java.util.concurrent.TimeUnit.DAYS;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;

/**
 * @author Stanislav Kashirin
 */
final class DeleteMetricsRandom {
    private DeleteMetricsRandom() {
    }

    public static DeleteMetricsParams params() {
        return params(1);
    }

    public static DeleteMetricsParams params(int atLeastShards) {
        assert atLeastShards > 0;

        var numIds = Stream.generate(() -> random().nextInt())
            .limit(random().nextInt(3) + atLeastShards)
            .collect(toList());

        return DeleteMetricsParams.newBuilder()
            .setProjectId(randomAlphanumeric(8))
            .setSelectors(randomAlphanumeric(8))
            .addAllNumIds(numIds)
            .setDescription(randomAlphanumeric(16))
            .setCreatedAt(System.currentTimeMillis() + random().nextInt(10_000))
            .setCreatedBy(randomAlphanumeric(8))
            .setPermanentDeletionAt(System.currentTimeMillis() + DAYS.toMillis(random().nextInt(10) + 20))
            .build();
    }

    private static Random random() {
        return ThreadLocalRandom.current();
    }
}
