package ru.yandex.solomon.gateway.utils;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class GridsTest {

    @Test
    public void div() {
        for (int a : Grids.allowedGridStepSeconds()) {
            for (int b : Grids.allowedGridStepSeconds()) {
                if (b > a) {
                    Assert.assertTrue(b % a == 0);
                }
            }
        }
    }

    @Test
    public void isValidGridSeconds() {
        Assert.assertTrue(Grids.isValidGridStepSeconds(15));
        Assert.assertFalse(Grids.isValidGridStepSeconds(16));
    }

    @Test
    public void roundUpMillis() {
        Assert.assertEquals(30_000, Grids.roundMillisUpToGrid(15_001));
        Assert.assertEquals(30_000, Grids.roundMillisUpToGrid(29_000));
        Assert.assertEquals(30_000, Grids.roundMillisUpToGrid(29_998));
        Assert.assertEquals(30_000, Grids.roundMillisUpToGrid(30_000));
        Assert.assertEquals(30_000, Grids.roundMillisUpToGrid(30_000));
        Assert.assertEquals(86_400_000, Grids.roundMillisUpToGrid(80_000_000));
        Assert.assertEquals(200_000_000, Grids.roundMillisUpToGrid(199_999_123));
    }

}
