package ru.yandex.solomon.gateway.utils.ser;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.solomon.util.www.ser.GggDurationSerializer;

/**
 * @author albazh
 */
public class GggDurationSerializerTest {

    @Test
    public void parseDuration() {
        Assert.assertEquals(null, GggDurationSerializer.parseDuration(""));
        Assert.assertEquals(null, GggDurationSerializer.parseDuration("aabb"));
        Assert.assertEquals(new GggDurationSerializer.Duration(17 * 60 * 60), GggDurationSerializer.parseDuration("17h"));
        Assert.assertEquals(new GggDurationSerializer.Duration(90 * 60), GggDurationSerializer.parseDuration("1h30m"));
        Assert.assertEquals(new GggDurationSerializer.Duration(2 * 24 * 60 * 60), GggDurationSerializer.parseDuration("2d"));
        Assert.assertEquals(new GggDurationSerializer.Duration(21 * 24 * 60 * 60), GggDurationSerializer.parseDuration("3w"));
        Assert.assertEquals(new GggDurationSerializer.Duration(22 * 24 * 60 * 60), GggDurationSerializer.parseDuration("3w1d"));
        Assert.assertEquals(new GggDurationSerializer.Duration(17), GggDurationSerializer.parseDuration("017s"));
    }

}
