package ru.yandex.solomon.gateway.viewHistory;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author albazh
 */
public class ViewHistoryUrlNormalizerTest {

    @Test
    public void normalizeUrl() {
        String orig = "/some/path/?" +
            "project=solomon&" +
            "cluster=salmon&" +
            "service=sys&" +
            "path=%2FIo%2FDisks%2FReads&" +
            "disk=!sda&" +
            "host=Sas&" +
            "graph=auto&" +
            "b=2016-06-03T11%3A12%3A19.057Z&" +
            "e=2016-06-09T02%3A35%3A27.496Z&" +
            "forceHost=woodpecker.search.yandex.net&" +
            "reviverClientId=1234&";

        String normalized = ViewHistoryUrlNormalizer.normalizeUrl(orig);

        Assert.assertEquals("/some/path/?" +
                "cluster=salmon&" +
                "disk=%21sda&" +
                "graph=auto&" +
                "host=Sas&" +
                "path=%2FIo%2FDisks%2FReads&" +
                "project=solomon&" +
                "service=sys",
            normalized);
    }
}
